/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.log;

import io.honeybadger.com.jcabi.log.Logger;
import java.util.concurrent.Callable;

public final class VerboseRunnable
implements Runnable {
    private final transient Runnable origin;
    private final transient boolean rethrow;
    private final transient boolean verbose;

    public VerboseRunnable(Runnable runnable) {
        this(runnable, false);
    }

    public VerboseRunnable(Callable<?> callable) {
        this(callable, false);
    }

    public VerboseRunnable(Callable<?> callable, boolean swallow) {
        this(callable, swallow, true);
    }

    public VerboseRunnable(final Callable<?> callable, boolean swallow, boolean vrbs) {
        this(new Runnable(){

            @Override
            public void run() {
                try {
                    callable.call();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException(ex);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            public String toString() {
                return callable.toString();
            }
        }, swallow, vrbs);
    }

    public VerboseRunnable(Runnable runnable, boolean swallow) {
        this(runnable, swallow, true);
    }

    public VerboseRunnable(Runnable runnable, boolean swallow, boolean vrbs) {
        this.origin = runnable;
        this.rethrow = !swallow;
        this.verbose = vrbs;
    }

    public String toString() {
        return this.origin.toString();
    }

    @Override
    public void run() {
        try {
            this.origin.run();
        }
        catch (RuntimeException ex) {
            if (this.rethrow) {
                Logger.warn(this, "Escalated exception: %s", this.tail(ex));
                throw ex;
            }
            Logger.warn(this, "Swallowed exception: %s", this.tail(ex));
        }
        catch (Error error) {
            if (this.rethrow) {
                Logger.error(this, "Escalated error: %s", this.tail(error));
                throw error;
            }
            Logger.error(this, "Swallowed error: %s", this.tail(error));
        }
        if (Thread.currentThread().isInterrupted()) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("The thread has been interrupted");
        }
    }

    private String tail(Throwable throwable) {
        String tail = this.verbose ? Logger.format("%[exception]s", throwable) : Logger.format("%[type]s('%s')", throwable, throwable.getMessage());
        return tail;
    }
}

