/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.com.jcabi.manifests;

import io.honeybadger.com.jcabi.log.Logger;
import io.honeybadger.com.jcabi.manifests.ClasspathMfs;
import io.honeybadger.com.jcabi.manifests.FilesMfs;
import io.honeybadger.com.jcabi.manifests.MfMap;
import io.honeybadger.com.jcabi.manifests.Mfs;
import io.honeybadger.com.jcabi.manifests.ServletMfs;
import io.honeybadger.com.jcabi.manifests.StreamsMfs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;

public final class Manifests
implements MfMap {
    private static final AtomicReference<MfMap> DEFAULT = new AtomicReference<Manifests>(new Manifests());
    private final transient Map<String, String> attributes;

    public Manifests() {
        this(new HashMap<String, String>(0));
    }

    public Manifests(Map<String, String> attrs) {
        this.attributes = new ConcurrentHashMap<String, String>(attrs);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(String key) {
        return this.attributes.containsKey(key);
    }

    @Override
    public boolean containsValue(String value) {
        return this.attributes.containsValue(value);
    }

    @Override
    public String get(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Map<String, String> getAsMap() {
        return new HashMap<String, String>(this.attributes);
    }

    @Override
    public Set<String> keySet() {
        return new HashSet<String>(this.attributes.keySet());
    }

    @Override
    public MfMap append(Mfs streams) throws IOException {
        ConcurrentHashMap<String, String> joined = new ConcurrentHashMap<String, String>(this.attributes);
        long start = System.currentTimeMillis();
        Collection<InputStream> list = streams.fetch();
        int saved = 0;
        int ignored = 0;
        for (InputStream stream : list) {
            for (Map.Entry<String, String> attr : Manifests.load(stream).entrySet()) {
                if (joined.containsKey(attr.getKey())) {
                    ++ignored;
                    continue;
                }
                joined.put(attr.getKey(), attr.getValue());
                ++saved;
            }
        }
        Logger.info(this, "%d attributes loaded from %d stream(s) in %[ms]s, %d saved, %d ignored: %[list]s", this.attributes.size(), list.size(), System.currentTimeMillis() - start, saved, ignored, new TreeSet<String>(this.attributes.keySet()));
        return new Manifests(joined);
    }

    public static String read(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute can't be empty");
        }
        if (!Manifests.exists(name)) {
            throw new IllegalArgumentException(Logger.format("Attribute '%s' not found in MANIFEST.MF file(s) among %d other attribute(s): %[list]s", name, DEFAULT.get().size(), new TreeSet<String>(DEFAULT.get().keySet())));
        }
        return DEFAULT.get().get(name);
    }

    public static boolean exists(String name) {
        if (name == null) {
            throw new IllegalArgumentException("attribute name can't be NULL");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("attribute name can't be empty");
        }
        return DEFAULT.get().containsKey(name);
    }

    @Deprecated
    public static void append(ServletContext ctx) throws IOException {
        MfMap current = DEFAULT.get();
        DEFAULT.compareAndSet(current, current.append(new ServletMfs(ctx)));
    }

    @Deprecated
    public static void append(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("file can't be NULL");
        }
        MfMap current = DEFAULT.get();
        DEFAULT.compareAndSet(current, current.append(new FilesMfs(file)));
    }

    @Deprecated
    public static void append(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("input stream can't be NULL");
        }
        MfMap current = DEFAULT.get();
        DEFAULT.compareAndSet(current, current.append(new StreamsMfs(stream)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> load(InputStream stream) throws IOException {
        ConcurrentHashMap<String, String> props = new ConcurrentHashMap<String, String>(0);
        try {
            Manifest manifest = new Manifest(stream);
            Attributes attrs = manifest.getMainAttributes();
            for (Object key : attrs.keySet()) {
                String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                props.put(key.toString(), value);
            }
            Logger.debug(Manifests.class, "%d attribute(s) loaded %[list]s", props.size(), new TreeSet(props.keySet()));
        }
        catch (RuntimeException ex) {
            Manifests.logLoadFailedError(ex);
        }
        finally {
            stream.close();
        }
        return props;
    }

    private static void logLoadFailedError(Exception exn) {
        Logger.error(Manifests.class, "#load(): failed %[exception]s", exn);
    }

    static {
        try {
            MfMap instance = DEFAULT.get();
            DEFAULT.compareAndSet(instance, instance.append(new ClasspathMfs()));
        }
        catch (IOException ex) {
            Manifests.logLoadFailedError(ex);
        }
    }
}

