/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.loader;

import io.honeybadger.com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.com.fasterxml.jackson.databind.InjectableValues;
import io.honeybadger.com.fasterxml.jackson.databind.JsonNode;
import io.honeybadger.com.fasterxml.jackson.databind.ObjectMapper;
import io.honeybadger.com.fasterxml.jackson.databind.node.ObjectNode;
import io.honeybadger.org.apache.http.HttpResponse;
import io.honeybadger.org.apache.http.client.fluent.Request;
import io.honeybadger.org.apache.http.client.fluent.Response;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Notice;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoneybadgerNoticeLoader {
    private static final int RETRIES = 3;
    public static final int RETRY_DELAY_MILLIS = 5000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setDefaultPropertyInclusion(JsonInclude.Value.construct(JsonInclude.Include.ALWAYS, JsonInclude.Include.NON_NULL)).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private ConfigContext config;

    public HoneybadgerNoticeLoader(ConfigContext config) {
        this.config = config;
    }

    String pullFaultJson(UUID faultId) throws IOException {
        Response response;
        String readApiKey = this.config.getHoneybadgerReadApiKey();
        if (readApiKey == null) {
            String msg = "Read API key must be set";
            throw new IllegalArgumentException(msg);
        }
        URI baseURI = URI.create(String.format("%s/%s/%s", this.config.getHoneybadgerUrl(), "v1/notices", faultId));
        String withAuth = String.format("%s/?auth_token=%s", baseURI, readApiKey);
        this.logger.debug("Querying for error details: {}", (Object)baseURI);
        HttpResponse httpResponse = null;
        for (int i = 0; i < 3 && (httpResponse = (response = Request.Get(withAuth).addHeader("Accept", "application/json").execute()).returnResponse()).getStatusLine().getStatusCode() != 200; ++i) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (i != 2) continue;
            String msg = String.format("Unable to get notice from API.\n[Response Status Code=%d]\n[Response Reason=%s]", httpResponse.getStatusLine().getStatusCode(), httpResponse.getStatusLine().getReasonPhrase());
            throw new IllegalArgumentException(msg);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        httpResponse.getEntity().writeTo(out);
        return out.toString();
    }

    public Notice findErrorDetails(UUID faultId) throws IOException {
        String jsonText = this.pullFaultJson(faultId);
        JsonNode originalJson = OBJECT_MAPPER.readTree(jsonText);
        JsonNode cgiData = originalJson.get("web_environment");
        ((ObjectNode)originalJson.get("request")).replace("cgi_data", cgiData);
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        OBJECT_MAPPER.setInjectableValues(injectableValues);
        injectableValues.addValue("config", (Object)this.config);
        Notice error = OBJECT_MAPPER.readValue(originalJson.toString(), Notice.class);
        return error;
    }
}

