/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter;

import io.honeybadger.com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.com.fasterxml.jackson.core.JsonProcessingException;
import io.honeybadger.com.fasterxml.jackson.databind.JsonNode;
import io.honeybadger.com.fasterxml.jackson.databind.ObjectMapper;
import io.honeybadger.org.apache.http.HttpHost;
import io.honeybadger.org.apache.http.HttpResponse;
import io.honeybadger.org.apache.http.HttpVersion;
import io.honeybadger.org.apache.http.client.fluent.Response;
import io.honeybadger.org.apache.http.entity.ContentType;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import io.honeybadger.reporter.dto.HttpServletRequestFactory;
import io.honeybadger.reporter.dto.Notice;
import io.honeybadger.reporter.dto.NoticeDetails;
import io.honeybadger.reporter.dto.PlayHttpRequestFactory;
import io.honeybadger.reporter.dto.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Http;

public class HoneybadgerReporter
implements NoticeReporter {
    private static Set<Class<?>> exceptionContextClasses = HoneybadgerReporter.findExceptionContextClasses();
    private ConfigContext config;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    public HoneybadgerReporter() {
        this(new SystemSettingsConfigContext());
    }

    public HoneybadgerReporter(ConfigContext config) {
        this.setConfig(config);
        if (config.getApiKey() == null) {
            throw new IllegalArgumentException("API key must be set");
        }
        if (config.getApiKey().isEmpty()) {
            throw new IllegalArgumentException("API key must not be empty");
        }
        if (config.getHoneybadgerUrl() == null) {
            throw new IllegalArgumentException("Honeybadger URL must be set");
        }
        if (config.getMaximumErrorReportingRetries() == null) {
            throw new IllegalArgumentException("Honeybadger property honeybadger.maximum_retry_attempts must be set");
        }
        if (config.getMaximumErrorReportingRetries() < 0) {
            throw new IllegalArgumentException("Honeybadger property honeybadger.maximum_retry_attempts must be an integer greater than or equal to 0");
        }
    }

    @Override
    public NoticeReportResult reportError(Throwable error) {
        return this.reportError(error, null, null, Collections.emptySet());
    }

    @Override
    public NoticeReportResult reportError(Throwable error, Object request) {
        return this.reportError(error, request, null, Collections.emptySet());
    }

    @Override
    public NoticeReportResult reportError(Throwable error, Object request, String message) {
        return this.reportError(error, request, message, Collections.emptySet());
    }

    @Override
    public NoticeReportResult reportError(Throwable error, Object request, String message, Iterable<String> tags) {
        return this.reportError(error, request, message, Collections.emptySet(), null);
    }

    @Override
    public NoticeReportResult reportError(Throwable error, Object request, String message, Iterable<String> tags, String fingerprint) {
        Request requestDetails;
        if (error == null) {
            return null;
        }
        Set<String> tagsSet = this.aggregateTags(tags);
        if (request == null) {
            return this.submitError(error, null, message, tagsSet, fingerprint);
        }
        if (request instanceof Request) {
            this.logger.debug("Reporting using a request DTO");
            requestDetails = (Request)request;
        } else if (this.supportsHttpServletRequest() && request instanceof HttpServletRequest) {
            this.logger.debug("Reporting from a servlet context");
            requestDetails = HttpServletRequestFactory.create(this.getConfig(), (HttpServletRequest)request);
        } else if (this.supportsPlayHttpRequest() && request instanceof Http.Request) {
            this.logger.debug("Reporting from the Play Framework");
            requestDetails = PlayHttpRequestFactory.create(this.getConfig(), (Http.Request)request);
        } else {
            this.logger.debug("No request object available");
            requestDetails = null;
        }
        return this.submitError(error, requestDetails, message, tagsSet, fingerprint);
    }

    @Override
    public ConfigContext getConfig() {
        return this.config;
    }

    protected Set<String> aggregateTags(Iterable<String> tags) {
        if (tags == null || tags == Collections.EMPTY_SET) {
            return Collections.emptySet();
        }
        Iterator<String> itr = tags.iterator();
        if (!itr.hasNext()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> tagHashSet = new LinkedHashSet<String>();
        while (itr.hasNext()) {
            String trimmed;
            String tag = itr.next();
            if (tag == null || (trimmed = tag.trim()).isEmpty()) continue;
            tagHashSet.add(trimmed);
        }
        return Collections.unmodifiableSet(tagHashSet);
    }

    protected boolean supportsHttpServletRequest() {
        try {
            Class.forName("javax.servlet.http.HttpServletRequest");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected boolean supportsPlayHttpRequest() {
        try {
            Class.forName("play.mvc.Http", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected NoticeReportResult submitError(Throwable error, Request request, String message, Set<String> tags, String fingerprint) {
        String json;
        String errorClassName = error.getClass().getName();
        if (errorClassName != null && this.getConfig().getExcludedClasses().contains(errorClassName)) {
            return null;
        }
        Notice notice = new Notice(this.getConfig());
        String reportedMessage = message != null && !message.isEmpty() ? message : HoneybadgerReporter.parseMessage(error);
        NoticeDetails noticeDetails = new NoticeDetails(this.getConfig(), error, tags, reportedMessage, fingerprint);
        notice.setError(noticeDetails);
        if (request != null) {
            notice.setRequest(request);
        }
        try {
            json = OBJECT_MAPPER.writeValueAsString(notice);
        }
        catch (JsonProcessingException e) {
            this.logger.error("JSON Serialization of the Notice Failed.", (Throwable)e);
            this.logger.error("Original Error", error);
            return null;
        }
        for (int retries = 0; retries <= this.config.getMaximumErrorReportingRetries(); ++retries) {
            try {
                HttpResponse response = this.sendToHoneybadger(json).returnResponse();
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode == 201) {
                    UUID id = this.parseErrorId(response);
                    return new NoticeReportResult(id, notice, error);
                }
                this.logger.error("Honeybadger did not respond with the correct code. Response was [{}]. Retries={}, Maximum={}", new Object[]{responseCode, retries, this.config.getMaximumErrorReportingRetries()});
                continue;
            }
            catch (IOException e) {
                String msg = String.format("There was an error when trying to send the error to Honeybadger. Retries=%d, Maximum=%d", retries, this.config.getMaximumErrorReportingRetries());
                this.logger.error(msg, (Throwable)e);
                this.logger.error("Original Error", error);
            }
        }
        return null;
    }

    private UUID parseErrorId(HttpResponse response) throws IOException {
        Throwable throwable = null;
        try (InputStream in = response.getEntity().getContent();){
            UUID uUID;
            Throwable throwable2;
            InputStreamReader reader;
            block13: {
                reader = new InputStreamReader(in, StandardCharsets.UTF_8);
                throwable2 = null;
                JsonNode responseNode = OBJECT_MAPPER.readTree(reader);
                if (!responseNode.has("id")) break block13;
                UUID uUID2 = UUID.fromString(responseNode.get("id").textValue());
                HoneybadgerReporter.$closeResource(throwable2, reader);
                return uUID2;
            }
            try {
                uUID = null;
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        HoneybadgerReporter.$closeResource(throwable2, reader);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            HoneybadgerReporter.$closeResource(throwable2, reader);
            return uUID;
        }
    }

    private static String parseMessage(Throwable throwable) {
        if (HoneybadgerReporter.exceptionClassHasContextedVariables(throwable.getClass())) {
            String msg = throwable.getMessage();
            int contextSeparatorPos = msg.indexOf("Exception Context:");
            if (contextSeparatorPos == -1) {
                return msg;
            }
            return msg.substring(0, contextSeparatorPos).trim();
        }
        return throwable.getMessage();
    }

    protected Response sendToHoneybadger(String jsonError) throws IOException {
        URI honeybadgerUrl = URI.create(String.format("%s/%s", this.getConfig().getHoneybadgerUrl(), "v1/notices"));
        io.honeybadger.org.apache.http.client.fluent.Request request = this.buildRequest(honeybadgerUrl, jsonError);
        return request.execute();
    }

    private io.honeybadger.org.apache.http.client.fluent.Request buildRequest(URI honeybadgerUrl, String jsonError) {
        io.honeybadger.org.apache.http.client.fluent.Request request = io.honeybadger.org.apache.http.client.fluent.Request.Post(honeybadgerUrl).addHeader("X-API-Key", this.getConfig().getApiKey()).addHeader("Accept", "application/json").version(HttpVersion.HTTP_1_1).bodyString(jsonError, ContentType.APPLICATION_JSON);
        if (System.getProperty("http.proxyHost") != null && !System.getProperty("http.proxyHost").isEmpty()) {
            int port = Integer.parseInt(System.getProperty("http.proxyPort"));
            HttpHost proxy = new HttpHost(System.getProperty("http.proxyHost"), port);
            request.viaProxy(proxy);
        }
        if (this.getConfig().getSocketTimeout() != null) {
            request.socketTimeout(this.getConfig().getSocketTimeout());
        }
        if (this.getConfig().getConnectTimeout() != null) {
            request.connectTimeout(this.getConfig().getConnectTimeout());
        }
        return request;
    }

    private static boolean exceptionClassHasContextedVariables(Class<?> clazz) {
        if (exceptionContextClasses == null || exceptionContextClasses.isEmpty()) {
            return false;
        }
        for (Class<?> exceptionClass : exceptionContextClasses) {
            if (!exceptionClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private static Set<Class<?>> findExceptionContextClasses() {
        String[] classNames = new String[]{"io.honeybadger.org.apache.commons.lang3.exception.ExceptionContext"};
        LinkedHashSet classes = new LinkedHashSet(classNames.length);
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return Collections.unmodifiableSet(classes);
    }

    protected void setConfig(ConfigContext config) {
        this.config = config;
    }
}

