/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.config;

import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.config.DefaultsConfigContext;
import io.honeybadger.util.HBCollectionUtils;
import io.honeybadger.util.HBStringUtils;
import java.net.URI;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public abstract class BaseChainedConfigContext
implements ConfigContext {
    public static final ConfigContext DEFAULT_CONFIG = new DefaultsConfigContext();
    private String environment;
    private URI honeybadgerUrl;
    private String apiKey;
    private Set<String> excludedSysProps = new HashSet<String>();
    private Set<String> excludedParams = new HashSet<String>();
    private Set<String> excludedClasses = new HashSet<String>();
    private String applicationPackage;
    private String honeybadgerReadApiKey;
    private Boolean feedbackFormDisplayed;
    private String feedbackFormPath;
    private String httpProxyHost;
    private Integer httpProxyPort;
    private Integer maximumErrorReportingRetries;
    private Integer socketTimeout;
    private Integer connectTimeout;

    public BaseChainedConfigContext() {
        this(DEFAULT_CONFIG);
    }

    public BaseChainedConfigContext(ConfigContext defaultingContext) {
        this.overwriteWithContext(defaultingContext);
    }

    @Override
    public String getEnvironment() {
        return this.environment;
    }

    public BaseChainedConfigContext setEnvironment(String environment) {
        this.environment = environment;
        return this;
    }

    @Override
    public URI getHoneybadgerUrl() {
        return this.honeybadgerUrl;
    }

    public BaseChainedConfigContext setHoneybadgerUrl(URI honeybadgerUrl) {
        this.honeybadgerUrl = honeybadgerUrl;
        return this;
    }

    @Override
    public String getApiKey() {
        return this.apiKey;
    }

    public BaseChainedConfigContext setApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Override
    public Set<String> getExcludedSysProps() {
        return this.excludedSysProps;
    }

    public BaseChainedConfigContext setExcludedSysProps(Set<String> excludedSysProps) {
        this.excludedSysProps = excludedSysProps;
        return this;
    }

    @Override
    public Set<String> getExcludedParams() {
        return this.excludedParams;
    }

    public BaseChainedConfigContext setExcludedParams(Set<String> excludedParams) {
        this.excludedParams = excludedParams;
        return this;
    }

    @Override
    public Set<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public BaseChainedConfigContext setExcludedClasses(Set<String> excludedClasses) {
        this.excludedClasses = excludedClasses;
        return this;
    }

    @Override
    public String getApplicationPackage() {
        return this.applicationPackage;
    }

    public BaseChainedConfigContext setApplicationPackage(String applicationPackage) {
        this.applicationPackage = applicationPackage;
        return this;
    }

    @Override
    public String getHoneybadgerReadApiKey() {
        return this.honeybadgerReadApiKey;
    }

    public BaseChainedConfigContext setHoneybadgerReadApiKey(String honeybadgerReadApiKey) {
        this.honeybadgerReadApiKey = honeybadgerReadApiKey;
        return this;
    }

    @Override
    public Boolean isFeedbackFormDisplayed() {
        return this.getFeedbackFormDisplayed();
    }

    @Override
    public String getFeedbackFormPath() {
        return this.feedbackFormPath;
    }

    public BaseChainedConfigContext setFeedbackFormPath(String feedbackFormPath) {
        this.feedbackFormPath = feedbackFormPath;
        return this;
    }

    @Override
    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public BaseChainedConfigContext setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
        return this;
    }

    @Override
    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public BaseChainedConfigContext setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
        return this;
    }

    @Override
    public Integer getMaximumErrorReportingRetries() {
        return this.maximumErrorReportingRetries;
    }

    public BaseChainedConfigContext getMaximumErrorReportingRetries(Integer maximumRetries) {
        this.maximumErrorReportingRetries = maximumRetries;
        return this;
    }

    @Override
    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public BaseChainedConfigContext setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public BaseChainedConfigContext setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public void overwriteWithContext(ConfigContext context) {
        if (HBStringUtils.isPresent(context.getEnvironment())) {
            this.environment = context.getEnvironment();
        }
        if (context.getHoneybadgerUrl() != null) {
            this.honeybadgerUrl = context.getHoneybadgerUrl();
        }
        if (HBStringUtils.isPresent(context.getApiKey())) {
            this.apiKey = context.getApiKey();
        }
        if (HBCollectionUtils.isPresent(context.getExcludedSysProps())) {
            HashSet<String> set = new HashSet<String>(context.getExcludedSysProps());
            set.add("honeybadger.api_key");
            set.add("honeybadger.excluded_sys_props");
            set.add("honeybadger.url");
            this.excludedSysProps = set;
        }
        if (HBCollectionUtils.isPresent(context.getExcludedParams())) {
            this.excludedParams = context.getExcludedParams();
        }
        if (HBCollectionUtils.isPresent(context.getExcludedClasses())) {
            this.excludedClasses = context.getExcludedClasses();
        }
        if (HBStringUtils.isPresent(context.getApplicationPackage())) {
            this.applicationPackage = context.getApplicationPackage();
        }
        if (HBStringUtils.isPresent(context.getHoneybadgerReadApiKey())) {
            this.honeybadgerReadApiKey = context.getHoneybadgerReadApiKey();
        }
        if (context.isFeedbackFormDisplayed() != null) {
            this.feedbackFormDisplayed = context.isFeedbackFormDisplayed();
        }
        if (HBStringUtils.isPresent(context.getFeedbackFormPath())) {
            this.feedbackFormPath = context.getFeedbackFormPath();
        }
        if (context.getMaximumErrorReportingRetries() != null) {
            this.maximumErrorReportingRetries = context.getMaximumErrorReportingRetries();
        }
        if (context.getSocketTimeout() != null) {
            this.socketTimeout = context.getSocketTimeout();
        }
        if (context.getConnectTimeout() != null) {
            this.connectTimeout = context.getConnectTimeout();
        }
    }

    public Boolean setFeedbackFormDisplayed(Boolean feedbackFormDisplayed) {
        if (feedbackFormDisplayed == null) {
            throw new IllegalArgumentException("This value should be only null during initialization");
        }
        this.feedbackFormDisplayed = feedbackFormDisplayed;
        return feedbackFormDisplayed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof BaseChainedConfigContext)) {
            return false;
        }
        BaseChainedConfigContext that = (BaseChainedConfigContext)o;
        return Objects.equals(this.environment, that.environment) && Objects.equals(this.honeybadgerUrl, that.honeybadgerUrl) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.excludedSysProps, that.excludedSysProps) && Objects.equals(this.excludedParams, that.excludedParams) && Objects.equals(this.excludedClasses, that.excludedClasses) && Objects.equals(this.applicationPackage, that.applicationPackage) && Objects.equals(this.honeybadgerReadApiKey, that.honeybadgerReadApiKey) && Objects.equals(this.feedbackFormDisplayed, that.feedbackFormDisplayed) && Objects.equals(this.feedbackFormPath, that.feedbackFormPath) && Objects.equals(this.httpProxyHost, that.httpProxyHost) && Objects.equals(this.httpProxyPort, that.httpProxyPort) && Objects.equals(this.maximumErrorReportingRetries, that.maximumErrorReportingRetries) && Objects.equals(this.socketTimeout, that.socketTimeout) && Objects.equals(this.connectTimeout, that.connectTimeout);
    }

    public String toString() {
        return "BaseChainedConfigContext{environment='" + this.environment + '\'' + ", honeybadgerUrl=" + this.honeybadgerUrl + ", apiKey='" + this.apiKey + '\'' + ", excludedSysProps=" + this.excludedSysProps + ", excludedParams=" + this.excludedParams + ", excludedClasses=" + this.excludedClasses + ", applicationPackage='" + this.applicationPackage + '\'' + ", honeybadgerReadApiKey='" + this.honeybadgerReadApiKey + '\'' + ", feedbackFormDisplayed=" + this.feedbackFormDisplayed + ", feedbackFormPath='" + this.feedbackFormPath + '\'' + ", httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", maximumErrorReportingRetries=" + this.maximumErrorReportingRetries + ", socketTimeout=" + this.socketTimeout + ", connectTimeout=" + this.connectTimeout + '}';
    }

    public int hashCode() {
        return Objects.hash(this.environment, this.honeybadgerUrl, this.apiKey, this.excludedSysProps, this.excludedParams, this.excludedClasses, this.applicationPackage, this.honeybadgerReadApiKey, this.feedbackFormDisplayed, this.feedbackFormPath, this.httpProxyHost, this.httpProxyPort, this.maximumErrorReportingRetries, this.socketTimeout, this.connectTimeout);
    }

    protected Boolean getFeedbackFormDisplayed() {
        return this.feedbackFormDisplayed;
    }
}

