/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.config;

import io.honeybadger.reporter.config.BaseChainedConfigContext;
import io.honeybadger.reporter.config.MapConfigContext;
import io.honeybadger.reporter.config.SystemSettingsConfigContext;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class SpringConfigContext
extends BaseChainedConfigContext {
    @Autowired
    public SpringConfigContext(Environment environment) {
        if (environment != null) {
            Map<String, String> mapProps = SpringConfigContext.environmentAsMap(environment);
            MapConfigContext mapConfigContext = new MapConfigContext(mapProps);
            this.overwriteWithContext(mapConfigContext);
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("Null Spring environment. Using defaults and system settings.");
            this.overwriteWithContext(new SystemSettingsConfigContext());
        }
    }

    protected static Map<String, String> environmentAsMap(Environment environment) {
        if (environment == null) {
            String msg = "Spring environment must not be null";
            throw new IllegalArgumentException(msg);
        }
        String[] keys = MapConfigContext.ALL_PROPERTIES;
        HashMap<String, String> map = new HashMap<String, String>(keys.length);
        for (String key : keys) {
            String value = environment.getProperty(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }
}

