/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.reporter.config.ConfigContext;
import io.honeybadger.reporter.dto.Cause;
import java.io.Serializable;
import java.util.LinkedList;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Causes
extends LinkedList<Cause>
implements Serializable {
    private static final long serialVersionUID = -5359764114506595006L;
    private static final int MAX_CAUSES = 100;

    public Causes(ConfigContext config, Throwable rootError) {
        if (rootError == null) {
            throw new IllegalArgumentException("Error can't be null");
        }
        this.addCauses(config, rootError);
    }

    void addCauses(ConfigContext config, Throwable rootError) {
        if (rootError.getCause() == null) {
            return;
        }
        Throwable lastCause = null;
        Throwable nextCause = rootError.getCause();
        int iterations = 0;
        do {
            this.addFirst(new Cause(config, nextCause));
            lastCause = nextCause;
        } while (null != (nextCause = nextCause.getCause()) && !lastCause.equals(nextCause) && ++iterations <= 100);
    }
}

