/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.com.fasterxml.jackson.annotation.JacksonInject;
import io.honeybadger.com.fasterxml.jackson.annotation.JsonCreator;
import io.honeybadger.com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.reporter.config.ConfigContext;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.MDC;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Details
extends LinkedHashMap<String, Map<String, String>>
implements Serializable {
    private static final long serialVersionUID = -6238693264237448645L;
    private final ConfigContext config;

    @JsonCreator
    public Details(@JacksonInject(value="config") ConfigContext config) {
        this.config = config;
    }

    void addDefaultDetails() {
        this.put("System Properties", this.systemProperties());
        this.put("MDC Properties", Details.mdcProperties());
    }

    protected static LinkedHashMap<String, String> mdcProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Map mdc = MDC.getCopyOfContextMap();
        if (mdc != null) {
            for (Map.Entry entry : mdc.entrySet()) {
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    protected Map<String, String> systemProperties() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Set<String> excludedSysProps = this.config.getExcludedSysProps();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String stringKey;
            Object key = entry.getKey();
            if (key == null || (stringKey = Objects.toString(key)).isEmpty() || excludedSysProps.contains(stringKey)) continue;
            map.put(stringKey, entry.getValue().toString());
        }
        return map;
    }
}

