/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.dto;

import io.honeybadger.com.fasterxml.jackson.annotation.JsonCreator;
import io.honeybadger.com.fasterxml.jackson.annotation.JsonInclude;
import io.honeybadger.com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Scanner;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Load
implements Serializable {
    private static final long serialVersionUID = 3398000045209329774L;
    private final Number one;
    private final Number five;
    private final Number fifteen;

    public Load() {
        Number[] loadAverages = Load.findLoadAverages();
        this.one = loadAverages[0];
        this.five = loadAverages[1];
        this.fifteen = loadAverages[2];
    }

    @JsonCreator
    public Load(@JsonProperty(value="one") Number one, @JsonProperty(value="five") Number five, @JsonProperty(value="fifteen") Number fifteen) {
        this.one = one;
        this.five = five;
        this.fifteen = fifteen;
    }

    static Number[] findLoadAverages() {
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        String os = osBean.getName();
        if (os.equals("Linux")) {
            return Load.findLinuxLoadAverages(osBean);
        }
        return Load.defaultLoadAverages(osBean);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Number[] findLinuxLoadAverages(OperatingSystemMXBean osBean) {
        File loadavg = new File("/proc/loadavg");
        if (loadavg.exists() && loadavg.isFile() && loadavg.canRead()) {
            try (Scanner scanner = new Scanner(loadavg, StandardCharsets.US_ASCII.name());){
                if (!scanner.hasNext()) {
                    Number[] numberArray2 = Load.defaultLoadAverages(osBean);
                    return numberArray2;
                }
                String line = scanner.nextLine();
                String[] values = line.split(" ", 4);
                Number[] numberArray = new Number[]{Double.parseDouble(values[0]), Double.parseDouble(values[1]), Double.parseDouble(values[2])};
                return numberArray;
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Load.class).debug("Error reading /proc/loadavg", (Throwable)e);
                return Load.defaultLoadAverages(osBean);
            }
        }
        LoggerFactory.getLogger(Load.class).debug("Couldn't fid or access /proc/loadavg");
        return Load.defaultLoadAverages(osBean);
    }

    static Number[] defaultLoadAverages(OperatingSystemMXBean osBean) {
        return new Number[]{osBean.getSystemLoadAverage(), null, null};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Load)) {
            return false;
        }
        Load load = (Load)o;
        return Objects.equals(this.getOne(), load.getOne()) && Objects.equals(this.getFive(), load.getFive()) && Objects.equals(this.getFifteen(), load.getFifteen());
    }

    public int hashCode() {
        return Objects.hash(this.getOne(), this.getFive(), this.getFifteen());
    }

    public String toString() {
        return "Load{one=" + this.getOne() + ", five=" + this.getFive() + ", fifteen=" + this.getFifteen() + '}';
    }

    public Number getOne() {
        return this.one;
    }

    public Number getFive() {
        return this.five;
    }

    public Number getFifteen() {
        return this.fifteen;
    }
}

