/*
 * Decompiled with CFR 0.152.
 */
package io.honeybadger.reporter.play;

import com.typesafe.config.Config;
import io.honeybadger.reporter.HoneybadgerReporter;
import io.honeybadger.reporter.NoticeReportResult;
import io.honeybadger.reporter.NoticeReporter;
import io.honeybadger.reporter.config.PlayConfigContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import javax.inject.Provider;
import play.Environment;
import play.Logger;
import play.api.OptionalSourceMapper;
import play.api.UsefulException;
import play.api.routing.Router;
import play.http.DefaultHttpErrorHandler;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;

public class HoneybadgerErrorHandler
extends DefaultHttpErrorHandler {
    private final NoticeReporter reporter;
    private final Environment environment;
    private final OptionalSourceMapper sourceMapper;

    @Inject
    public HoneybadgerErrorHandler(Config config, Environment environment, OptionalSourceMapper sourceMapper, Provider<Router> routes) {
        super(config, environment, sourceMapper, routes);
        this.environment = environment;
        this.sourceMapper = sourceMapper;
        PlayConfigContext context = new PlayConfigContext(config, environment);
        this.reporter = new HoneybadgerReporter(context);
    }

    public CompletionStage<Result> onServerError(Http.RequestHeader request, Throwable exception) {
        NoticeReportResult errorResult = this.getReporter().reportError(exception, request);
        try {
            UsefulException usefulException = this.throwableToUsefulException(exception);
            String honeybadgerErrorId = errorResult != null && errorResult.getId() != null ? errorResult.getId().toString() : String.format("play-error-%s", usefulException.id);
            usefulException.id = honeybadgerErrorId;
            this.logServerError(request, usefulException);
            switch (this.getEnvironment().mode()) {
                case PROD: {
                    return this.onProdServerError(request, usefulException);
                }
            }
            return this.onDevServerError(request, usefulException);
        }
        catch (Exception e) {
            Logger.error((String)"Error while handling error", (Throwable)e);
            return CompletableFuture.completedFuture(Results.internalServerError());
        }
    }

    protected NoticeReporter getReporter() {
        return this.reporter;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected OptionalSourceMapper getSourceMapper() {
        return this.sourceMapper;
    }
}

