/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.opentelemetry;

import com.google.common.base.Preconditions;
import io.honeycomb.opentelemetry.DistroMetadata;
import io.honeycomb.opentelemetry.EnvironmentConfiguration;
import io.honeycomb.opentelemetry.sdk.trace.samplers.DeterministicTraceSampler;
import io.honeycomb.opentelemetry.sdk.trace.spanprocessors.BaggageSpanProcessor;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import io.opentelemetry.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporter;
import io.opentelemetry.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import io.opentelemetry.instrumentation.resources.OsResource;
import io.opentelemetry.instrumentation.resources.ProcessRuntimeResource;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public final class OpenTelemetryConfiguration {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ContextPropagators propagators;
        private Sampler sampler = new DeterministicTraceSampler(1);
        private final List<SpanProcessor> additionalSpanProcessors = new ArrayList<SpanProcessor>(){
            {
                this.add(new BaggageSpanProcessor());
            }
        };
        private AttributesBuilder resourceAttributes = Attributes.builder();
        private Boolean enableDebug = false;
        private String tracesApiKey;
        private String tracesDataset;
        private String tracesEndpoint;
        private String serviceName;
        private String otelExporterOtlpProtocol = EnvironmentConfiguration.getOtelExporterOtlpProtocol();

        private Builder() {
        }

        public Builder setApiKey(String apiKey) {
            this.setTracesApiKey(apiKey);
            return this;
        }

        public Builder setTracesApiKey(String apiKey) {
            this.tracesApiKey = apiKey;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.setTracesDataset(dataset);
            return this;
        }

        public Builder setTracesDataset(String dataset) {
            this.tracesDataset = dataset;
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.setTracesEndpoint(endpoint);
            return this;
        }

        public Builder setTracesEndpoint(String endpoint) {
            this.tracesEndpoint = endpoint;
            return this;
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Builder setPropagators(ContextPropagators propagators) {
            this.propagators = propagators;
            return this;
        }

        public Builder setSampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public Builder addSpanProcessor(SpanProcessor spanProcessor) {
            this.additionalSpanProcessors.add(spanProcessor);
            return this;
        }

        public Builder enableDebug(boolean enabled) {
            this.enableDebug = enabled;
            return this;
        }

        public Builder addResourceAttribute(String key, String value) {
            this.resourceAttributes.put(key, value);
            return this;
        }

        public Builder addResourceAttribute(String key, long value) {
            this.resourceAttributes.put(key, value);
            return this;
        }

        public Builder addResourceAttribute(String key, double value) {
            this.resourceAttributes.put(key, value);
            return this;
        }

        public Builder addResourceAttribute(String key, boolean value) {
            this.resourceAttributes.put(key, value);
            return this;
        }

        public Builder addResourceAttribute(String key, String ... value) {
            this.resourceAttributes.put(key, value);
            return this;
        }

        public Builder setOtlpProtocol(String protocol) {
            this.otelExporterOtlpProtocol = protocol;
            return this;
        }

        public OpenTelemetry buildAndRegisterGlobal() {
            OpenTelemetry sdk = this.build();
            GlobalOpenTelemetry.set((OpenTelemetry)sdk);
            return sdk;
        }

        public OpenTelemetry build() {
            Preconditions.checkNotNull((Object)this.sampler, (Object)"sampler must be non-null");
            Logger logger = Logger.getLogger(OpenTelemetryConfiguration.class.getName());
            if (!EnvironmentConfiguration.isPresent((String)this.serviceName)) {
                logger.warning(EnvironmentConfiguration.getErrorMessage((String)"service name", (String)"SERVICE_NAME") + " If left unset, this will show up in Honeycomb as unknown_service:java");
            }
            if (EnvironmentConfiguration.isPresent((String)this.tracesApiKey) && !EnvironmentConfiguration.isLegacyKey((String)this.tracesApiKey) && EnvironmentConfiguration.isPresent((String)this.tracesDataset)) {
                if (EnvironmentConfiguration.isPresent((String)this.serviceName)) {
                    System.out.printf("WARN: Dataset is ignored in favor of service name. Data will be sent to service name: %s%n", this.serviceName);
                } else {
                    System.out.printf("WARN: Dataset is ignored in favor of service name.%n", new Object[0]);
                }
            }
            SdkTracerProviderBuilder tracerProviderBuilder = SdkTracerProvider.builder();
            tracerProviderBuilder.setSampler(this.sampler);
            this.additionalSpanProcessors.forEach(arg_0 -> ((SdkTracerProviderBuilder)tracerProviderBuilder).addSpanProcessor(arg_0));
            if (this.enableDebug.booleanValue()) {
                tracerProviderBuilder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create()));
            }
            SpanExporter spanExporter = this.getSpanExporter(logger);
            tracerProviderBuilder.addSpanProcessor((SpanProcessor)BatchSpanProcessor.builder((SpanExporter)spanExporter).build());
            DistroMetadata.getSDKMetadata().forEach((arg_0, arg_1) -> ((AttributesBuilder)this.resourceAttributes).put(arg_0, arg_1));
            if (StringUtils.isNotEmpty((CharSequence)this.serviceName)) {
                this.resourceAttributes.put("service.name", this.serviceName);
            }
            tracerProviderBuilder.setResource(Resource.getDefault().merge(OsResource.get()).merge(ProcessRuntimeResource.get()).merge(Resource.create((Attributes)this.resourceAttributes.build())));
            if (this.propagators == null) {
                this.propagators = ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((TextMapPropagator[])new TextMapPropagator[]{W3CTraceContextPropagator.getInstance(), W3CBaggagePropagator.getInstance()}));
            }
            return OpenTelemetrySdk.builder().setTracerProvider(tracerProviderBuilder.build()).setPropagators(this.propagators).build();
        }

        private SpanExporter getSpanExporter(Logger logger) {
            return this.otelExporterOtlpProtocol.equals("http/protobuf") ? this.createHttpSpanExporter(logger) : this.createGrpcSpanExporter(logger);
        }

        private SpanExporter createGrpcSpanExporter(Logger logger) {
            OtlpGrpcSpanExporterBuilder builder = OtlpGrpcSpanExporter.builder();
            if (this.tracesEndpoint != null) {
                builder.setEndpoint(this.tracesEndpoint);
            } else {
                builder.setEndpoint("https://api.honeycomb.io:443");
            }
            if (EnvironmentConfiguration.isPresent((String)this.tracesApiKey)) {
                Map headers = EnvironmentConfiguration.getTracesHeaders((String)this.tracesApiKey, (String)this.tracesDataset);
                headers.entrySet().forEach(entry -> builder.addHeader((String)entry.getKey(), (String)entry.getValue()));
                if (EnvironmentConfiguration.isLegacyKey((String)this.tracesApiKey) && !EnvironmentConfiguration.isPresent((String)this.tracesDataset)) {
                    logger.warning(EnvironmentConfiguration.getErrorMessage((String)"dataset", (String)"HONEYCOMB_DATASET"));
                }
            } else {
                logger.warning(EnvironmentConfiguration.getErrorMessage((String)"API key", (String)"HONEYCOMB_API_KEY"));
            }
            return builder.build();
        }

        private SpanExporter createHttpSpanExporter(Logger logger) {
            String endpoint;
            String string = endpoint = StringUtils.isNotEmpty((CharSequence)this.tracesEndpoint) ? this.tracesEndpoint : "https://api.honeycomb.io:443";
            if (!endpoint.endsWith("/v1/traces")) {
                endpoint = endpoint + "/v1/traces";
            }
            OtlpHttpSpanExporterBuilder builder = OtlpHttpSpanExporter.builder();
            builder.setEndpoint(endpoint);
            if (EnvironmentConfiguration.isPresent((String)this.tracesApiKey)) {
                Map headers = EnvironmentConfiguration.getTracesHeaders((String)this.tracesApiKey, (String)this.tracesDataset);
                headers.entrySet().forEach(entry -> builder.addHeader((String)entry.getKey(), (String)entry.getValue()));
                if (EnvironmentConfiguration.isLegacyKey((String)this.tracesApiKey) && !EnvironmentConfiguration.isPresent((String)this.tracesDataset)) {
                    logger.warning(EnvironmentConfiguration.getErrorMessage((String)"dataset", (String)"HONEYCOMB_DATASET"));
                }
            } else {
                logger.warning(EnvironmentConfiguration.getErrorMessage((String)"API key", (String)"HONEYCOMB_API_KEY"));
            }
            return builder.build();
        }
    }
}

