/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.ResponseObserver;
import io.honeycomb.libhoney.responses.ClientRejected;
import io.honeycomb.libhoney.responses.ServerAccepted;
import io.honeycomb.libhoney.responses.ServerRejected;
import io.honeycomb.libhoney.responses.Unknown;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDebugResponseObserver
implements ResponseObserver {
    protected static final String ERROR_TEMPLATE_401 = "Server responded with a 401 HTTP error code to a batch request. This is likely caused by using an incorrect 'Team Write Key'. Check https://ui.honeycomb.io/account to verify your team write key. Rejected event: {}";
    protected static final String ERROR_TEMPLATE_UNKNOWN_HOST_EXCEPTION = "Could not reach destination server. This could be due to 1) invalid apiHost 2) Could not resolve apiHost (firewall? dns?) 3) problem with proxy configuration or authentication. Unknown event: {}";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDebugResponseObserver.class);
    private static final int STATUS_UNAUTHORIZED = 401;

    @Override
    public void onServerAccepted(ServerAccepted serverAccepted) {
        LOG.trace("Event successfully sent to Honeycomb: {}", (Object)serverAccepted);
    }

    @Override
    public void onServerRejected(ServerRejected serverRejected) {
        if (serverRejected.getBatchData().getBatchStatusCode() == 401) {
            this.handle401(serverRejected);
        } else {
            LOG.debug("Event rejected by Honeycomb server: {}", (Object)serverRejected);
        }
    }

    protected void handle401(ServerRejected serverRejected) {
        LOG.debug(ERROR_TEMPLATE_401, (Object)serverRejected);
    }

    @Override
    public void onClientRejected(ClientRejected clientRejected) {
        LOG.debug("Event rejected on the client side: {}", (Object)clientRejected);
    }

    @Override
    public void onUnknown(Unknown unknown) {
        if (unknown.getException() != null && UnknownHostException.class.isAssignableFrom(unknown.getException().getClass())) {
            LOG.debug(ERROR_TEMPLATE_UNKNOWN_HOST_EXCEPTION, (Object)unknown);
        } else {
            LOG.debug("Received an unknown error while trying to send Event to Honeycomb: {}", (Object)unknown);
        }
    }
}

