/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.Event;
import io.honeycomb.libhoney.HoneyClient;
import io.honeycomb.libhoney.Options;
import io.honeycomb.libhoney.ValueSupplier;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class EventFactory {
    private final HoneyClient client;
    private final URI apiHost;
    private final String writeKey;
    private final String dataset;
    private final int sampleRate;
    private final Map<String, Object> fields;
    private final Map<String, ValueSupplier<?>> dynamicFields;

    EventFactory(HoneyClient client, URI apiHost, String writeKey, String dataset, int sampleRate, Map<String, Object> fields, Map<String, ValueSupplier<?>> dynamicFields) {
        this.client = client;
        this.apiHost = apiHost;
        this.writeKey = writeKey;
        this.dataset = dataset;
        this.sampleRate = sampleRate;
        this.fields = new HashMap<String, Object>(fields);
        this.dynamicFields = new HashMap(dynamicFields);
    }

    EventFactory(HoneyClient client, Options options) {
        this(client, options.getApiHost(), options.getWriteKey(), options.getDataset(), options.getSampleRate(), options.getGlobalFields(), options.getGlobalDynamicFields());
    }

    public Event createEvent() {
        return new Event(this.client, this.apiHost, this.writeKey, this.dataset, this.sampleRate, this.fields, this.dynamicFields);
    }

    public void send(Map<String, ?> fields) {
        ((Event)this.createEvent().addFields(fields)).send();
    }

    public Builder copy() {
        return Builder.newBuilder(this.client).setApiHost(this.apiHost).setDataset(this.dataset).setSampleRate(this.sampleRate).setWriteKey(this.writeKey).addDynamicFields(this.dynamicFields).addFields(this.fields);
    }

    public static final class Builder {
        private final HoneyClient client;
        private final Map<String, Object> fields = new HashMap<String, Object>();
        private final Map<String, ValueSupplier<?>> dynamicFields = new HashMap();
        private URI apiHost;
        private String writeKey;
        private String dataset;
        private int sampleRate;

        private Builder(HoneyClient client) {
            this.client = client;
        }

        public EventFactory build() {
            return new EventFactory(this.client, this.apiHost, this.writeKey, this.dataset, this.sampleRate, this.fields, this.dynamicFields);
        }

        public Builder setApiHost(URI apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public Builder setWriteKey(String writeKey) {
            this.writeKey = writeKey;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder addFields(Map<String, ?> fields) {
            this.fields.putAll(fields);
            return this;
        }

        public Builder addField(String fieldKey, Object fieldValue) {
            this.fields.put(fieldKey, fieldValue);
            return this;
        }

        public Builder addDynamicFields(Map<String, ? extends ValueSupplier<?>> dynamicFields) {
            this.dynamicFields.putAll(dynamicFields);
            return this;
        }

        public Builder addDynamicField(String dynamicFieldKey, ValueSupplier<?> dynamicFieldSupplier) {
            this.dynamicFields.put(dynamicFieldKey, dynamicFieldSupplier);
            return this;
        }

        public static Builder newBuilder(HoneyClient client) {
            return new Builder(client);
        }
    }
}

