/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.Event;
import io.honeycomb.libhoney.EventFactory;
import io.honeycomb.libhoney.EventPostProcessor;
import io.honeycomb.libhoney.LibHoney;
import io.honeycomb.libhoney.Options;
import io.honeycomb.libhoney.ResponseObserver;
import io.honeycomb.libhoney.TransportOptions;
import io.honeycomb.libhoney.ValueSupplier;
import io.honeycomb.libhoney.eventdata.ResolvedEvent;
import io.honeycomb.libhoney.responses.impl.EventResponseFactory;
import io.honeycomb.libhoney.transport.Transport;
import io.honeycomb.libhoney.transport.batch.ClockProvider;
import io.honeycomb.libhoney.transport.batch.impl.SystemClockProvider;
import io.honeycomb.libhoney.transport.impl.BatchingHttpTransport;
import io.honeycomb.libhoney.utils.Assert;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoneyClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HoneyClient.class);
    private final AtomicBoolean logAdditionalPostProcessorErrors = new AtomicBoolean(true);
    private final AtomicBoolean logAdditionalDynamicFieldsErrors = new AtomicBoolean(true);
    private static final String POST_PROCESSING_ERROR_LOG_MESSAGE = "Event post-processor threw an exception, so the event being processed could not be submitted to HoneyComb. Future post-processing errors will be logged at DEBUG level. A ClientRejected response has been published to the ResponseObservers. Please register a ResponseObserver to view these errors.";
    private static final String DYNAMIC_FIELDS_ERROR_LOG_MESSAGE = "Dynamic fields resolution threw an exception, so the event being resolved could not be submitted to HoneyComb. Future dynamic field resolution errors will be logged at DEBUG level. A ClientRejected response has been published to the ResponseObservers. Please register a ResponseObserver to view these errors.";
    private final Transport transport;
    private final EventFactory globalEventFactory;
    private final Random sampler = new Random();
    private final EventPostProcessor postProcessor;
    private final ClockProvider clock;

    public HoneyClient(Options options) {
        this(options, LibHoney.transportOptions().build());
    }

    public HoneyClient(Options options, TransportOptions transportOptions) {
        this(options, BatchingHttpTransport.init(transportOptions), SystemClockProvider.getInstance());
        LOG.info("Initialized HoneyClient with default HTTP batching transport. Basic config: {}. Transport config: {}.", (Object)options, (Object)transportOptions);
    }

    public HoneyClient(Options options, Transport transport) {
        this(options, transport, SystemClockProvider.getInstance());
    }

    public HoneyClient(Options options, Transport transport, ClockProvider clock) {
        this.transport = transport;
        this.globalEventFactory = new EventFactory(this, options);
        this.postProcessor = options.getEventPostProcessor();
        this.clock = clock;
    }

    private boolean isSampled(Event event) {
        return this.sampler.nextInt(event.getSampleRate()) == 0;
    }

    private ResolvedEvent constructResolvedEvent(Event event) {
        int fieldsSize = event.getDynamicFields().size() + event.getFields().size();
        HashMap<String, Object> resolvedFields = new HashMap<String, Object>(fieldsSize);
        try {
            this.resolveDynamicFields(event.getDynamicFields(), resolvedFields);
        }
        catch (Exception e) {
            this.transport.getResponseObservable().publish(EventResponseFactory.dynamicFieldResolutionError(event, e));
            if (this.logAdditionalDynamicFieldsErrors.compareAndSet(true, false)) {
                LOG.error(DYNAMIC_FIELDS_ERROR_LOG_MESSAGE, (Throwable)e);
            } else {
                LOG.debug("Dynamic field resolution failed with exception", (Throwable)e);
            }
            return null;
        }
        resolvedFields.putAll(event.getFields());
        ResolvedEvent internalEvent = ResolvedEvent.of(resolvedFields, event, this.clock);
        if (internalEvent.getTimestamp() == null) {
            internalEvent.setTimestamp(this.clock.getWallTime());
        }
        if (this.postProcessor != null) {
            try {
                this.postProcessor.process(internalEvent);
            }
            catch (Exception e) {
                this.transport.getResponseObservable().publish(EventResponseFactory.postProcessorError(internalEvent, e));
                if (this.logAdditionalPostProcessorErrors.compareAndSet(true, false)) {
                    LOG.error(POST_PROCESSING_ERROR_LOG_MESSAGE, (Throwable)e);
                } else {
                    LOG.debug("Dynamic field resolution failed with exception", (Throwable)e);
                }
                return null;
            }
        }
        this.assertThatEventIsValid(internalEvent);
        return internalEvent;
    }

    private void assertThatEventIsValid(ResolvedEvent event) {
        Assert.notNull(event.getApiHost(), "Validation failed: apiHost must not be null");
        Assert.notEmpty(event.getWriteKey(), "Validation failed: writeKey must not be null or empty");
        Assert.notEmpty(event.getDataset(), "Validation failed: dataset must not be null or empty");
        Assert.isTrue(event.getSampleRate() > 0, "Validation failed: invalid samplerate, must be greater than 1");
        Assert.notEmpty(event.getFields(), "Validation failed: event must have at least 1 key-value pair in its fields");
    }

    private void resolveDynamicFields(Map<String, ValueSupplier<?>> dynamicFields, Map<String, Object> dataMap) {
        for (Map.Entry<String, ValueSupplier<?>> next : dynamicFields.entrySet()) {
            dataMap.put(next.getKey(), next.getValue().supply());
        }
    }

    void sendEvent(Event event) {
        if (this.isSampled(event)) {
            this.sendEventPresampled(event);
        } else {
            LOG.trace("Event not sampled: {}", (Object)event);
            this.transport.getResponseObservable().publish(EventResponseFactory.notSampled(event));
        }
    }

    void sendEventPresampled(Event event) {
        ResolvedEvent resolvedEvent = this.constructResolvedEvent(event);
        if (resolvedEvent != null) {
            boolean submitted = this.transport.submit(resolvedEvent);
            LOG.debug("Resolved event accepted onto queue: {}", (Object)resolvedEvent);
            if (!submitted) {
                LOG.debug("Resolved event rejected due to queue overflow: {}", (Object)resolvedEvent);
                this.transport.getResponseObservable().publish(EventResponseFactory.queueOverflow(resolvedEvent));
            }
        }
    }

    public Event createEvent() {
        return this.globalEventFactory.createEvent();
    }

    public EventFactory.Builder buildEventFactory() {
        return this.globalEventFactory.copy();
    }

    public void send(Map<String, ?> fields) {
        this.globalEventFactory.send(fields);
    }

    public void addResponseObserver(ResponseObserver observer) {
        this.transport.getResponseObservable().add(observer);
    }

    public void removeResponseObserver(ResponseObserver observer) {
        this.transport.getResponseObservable().remove(observer);
    }

    public void setAsDefault() {
        LibHoney.setDefault(this);
    }

    public void closeOnShutdown() {
        LibHoney.closeOnShutdown(this);
    }

    @Override
    public void close() {
        LOG.info("Close called on HoneyClient. Closing...");
        try {
            this.transport.close();
        }
        catch (Exception e) {
            LOG.error("Closing HoneyClient's internals threw an exception", (Throwable)e);
        }
        LOG.info("Finished close.");
    }
}

