/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.HoneyClient;
import io.honeycomb.libhoney.Options;
import io.honeycomb.libhoney.TransportOptions;

public final class LibHoney {
    private static volatile HoneyClient defaultClient;

    private LibHoney() {
    }

    public static HoneyClient create(Options options) {
        return new HoneyClient(options);
    }

    public static HoneyClient create(Options options, TransportOptions transportOptions) {
        return new HoneyClient(options, transportOptions);
    }

    public static Options.Builder options() {
        return Options.builder();
    }

    public static TransportOptions.Builder transportOptions() {
        return TransportOptions.builder();
    }

    public static void setDefault(HoneyClient client) {
        defaultClient = client;
    }

    public static HoneyClient getDefault() {
        if (defaultClient == null) {
            throw new IllegalStateException("Default LibHoney has not been initialised");
        }
        return defaultClient;
    }

    public static void closeOnShutdown(final HoneyClient client) {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                client.close();
            }
        }));
    }
}

