/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.transport.batch.ClockProvider;
import io.honeycomb.libhoney.transport.batch.impl.SystemClockProvider;

public final class Metrics {
    public static final long ABSENT_TIME = -1L;
    private final ClockProvider clock;
    private volatile Long enqueueTime;
    private volatile Long startOfHttpRequestTime;
    private volatile Long endOfHttpRequestTime;

    private Metrics(ClockProvider clock) {
        this.clock = clock;
        this.enqueueTime = null;
        this.startOfHttpRequestTime = null;
        this.endOfHttpRequestTime = null;
    }

    public static Metrics create(ClockProvider clock) {
        return new Metrics(clock);
    }

    public static Metrics create() {
        return new Metrics(SystemClockProvider.getInstance());
    }

    public void markEnqueueTime() {
        this.enqueueTime = this.clock.getMonotonicTime();
    }

    public void markStartOfHttpRequest() {
        this.startOfHttpRequestTime = this.clock.getMonotonicTime();
    }

    public void markEndOfHttpRequest() {
        this.endOfHttpRequestTime = this.clock.getMonotonicTime();
    }

    public long getQueueDuration() {
        if (this.enqueueTime == null || this.startOfHttpRequestTime == null) {
            return -1L;
        }
        return this.startOfHttpRequestTime - this.enqueueTime;
    }

    public long getTotalDuration() {
        if (this.enqueueTime == null || this.endOfHttpRequestTime == null) {
            return -1L;
        }
        return this.endOfHttpRequestTime - this.enqueueTime;
    }

    public long getHttpRequestDuration() {
        if (this.startOfHttpRequestTime == null || this.endOfHttpRequestTime == null) {
            return -1L;
        }
        return this.endOfHttpRequestTime - this.startOfHttpRequestTime;
    }

    public String toString() {
        return "Metrics{clock=" + this.clock + ", enqueueTime=" + this.enqueueTime + ", startOfHttpRequestTime=" + this.startOfHttpRequestTime + ", endOfHttpRequestTime=" + this.endOfHttpRequestTime + '}';
    }
}

