/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.EventPostProcessor;
import io.honeycomb.libhoney.ValueSupplier;
import io.honeycomb.libhoney.utils.Assert;
import io.honeycomb.libhoney.utils.ObjectUtils;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Options {
    public static final URI DEFAULT_API_HOST = URI.create("https://api.honeycomb.io/");
    public static final String DEFAULT_WRITE_KEY = null;
    public static final String DEFAULT_DATASET = null;
    public static final String DEFAULT_NON_CLASSIC_DATASET = "unknown_dataset";
    public static final int DEFAULT_SAMPLE_RATE = 1;
    public static final Map<String, Object> DEFAULT_FIELDS = Collections.emptyMap();
    public static final Map<String, ValueSupplier<?>> DEFAULT_DYNAMIC_FIELDS = Collections.emptyMap();
    public static final EventPostProcessor DEFAULT_EVENT_POST_PROCESSOR = null;
    private final URI apiHost;
    private final String writeKey;
    private final String dataset;
    private final int sampleRate;
    private final Map<String, Object> globalFields;
    private final Map<String, ValueSupplier<?>> globalDynamicFields;
    private final EventPostProcessor eventPostProcessor;

    Options(URI apiHost, String writeKey, String dataset, Integer sampleRate, Map<String, Object> globalFields, Map<String, ValueSupplier<?>> globalDynamicFields, EventPostProcessor eventPostProcessor) {
        this.apiHost = ObjectUtils.getOrDefault(apiHost, DEFAULT_API_HOST);
        this.writeKey = ObjectUtils.getOrDefault(writeKey, DEFAULT_WRITE_KEY);
        this.dataset = ObjectUtils.getOrDefault(dataset, DEFAULT_DATASET);
        this.globalFields = new HashMap<String, Object>(ObjectUtils.getOrDefault(globalFields, DEFAULT_FIELDS));
        this.globalDynamicFields = new HashMap(ObjectUtils.getOrDefault(globalDynamicFields, DEFAULT_DYNAMIC_FIELDS));
        this.sampleRate = ObjectUtils.getOrDefault(sampleRate, 1);
        this.eventPostProcessor = ObjectUtils.getOrDefault(eventPostProcessor, DEFAULT_EVENT_POST_PROCESSOR);
        Assert.isTrue(this.sampleRate >= 1, "sampleRate must be 1 or greater");
    }

    private boolean isClassic() {
        return this.writeKey == null || this.writeKey.length() == 0 || this.writeKey.length() == 32;
    }

    public URI getApiHost() {
        return this.apiHost;
    }

    public String getWriteKey() {
        return this.writeKey;
    }

    public String getDataset() {
        if (this.isClassic()) {
            return this.dataset;
        }
        if (this.dataset == null || this.dataset.trim().length() == 0) {
            System.err.println("WARN: Dataset is empty or whitespace, using default: unknown_dataset");
            return DEFAULT_NON_CLASSIC_DATASET;
        }
        String trimmed = this.dataset.trim();
        if (this.dataset != trimmed) {
            System.err.println("WARN: Dataset has unexpected whitespace, using trimmed version: " + trimmed);
        }
        return trimmed;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public Map<String, Object> getGlobalFields() {
        return this.globalFields;
    }

    public Map<String, ValueSupplier<?>> getGlobalDynamicFields() {
        return this.globalDynamicFields;
    }

    public EventPostProcessor getEventPostProcessor() {
        return this.eventPostProcessor;
    }

    static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "Options{apiHost=" + this.apiHost + ", writeKey=**********, dataset='" + this.getDataset() + '\'' + ", sampleRate=" + this.sampleRate + ", globalFields=" + this.globalFields + ", globalDynamicFields=" + this.globalDynamicFields + ", eventPostProcessor=" + this.eventPostProcessor + '}';
    }

    public static class Builder {
        private URI apiHost;
        private String writeKey;
        private String dataset;
        private Integer sampleRate;
        private Map<String, Object> globalFields;
        private Map<String, ValueSupplier<?>> globalDynamicFields;
        private EventPostProcessor eventPostProcessor;

        public Options build() {
            return new Options(this.apiHost, this.writeKey, this.dataset, this.sampleRate, this.globalFields, this.globalDynamicFields, this.eventPostProcessor);
        }

        public URI getApiHost() {
            return this.apiHost;
        }

        public Builder setApiHost(URI apiHost) {
            this.apiHost = apiHost;
            return this;
        }

        public String getWriteKey() {
            return this.writeKey;
        }

        public Builder setWriteKey(String writeKey) {
            this.writeKey = writeKey;
            return this;
        }

        public String getDataset() {
            return this.dataset;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Integer getSampleRate() {
            return this.sampleRate;
        }

        public Builder setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Map<String, ?> getGlobalFields() {
            return this.globalFields;
        }

        public Builder setGlobalFields(Map<String, ?> globalFields) {
            this.globalFields = new HashMap(globalFields);
            return this;
        }

        public Map<String, ValueSupplier<?>> getGlobalDynamicFields() {
            return this.globalDynamicFields;
        }

        public Builder setGlobalDynamicFields(Map<String, ? extends ValueSupplier<?>> globalDynamicFields) {
            this.globalDynamicFields = new HashMap(globalDynamicFields);
            return this;
        }

        public EventPostProcessor getEventPostProcessor() {
            return this.eventPostProcessor;
        }

        public Builder setEventPostProcessor(EventPostProcessor eventPostProcessor) {
            this.eventPostProcessor = eventPostProcessor;
            return this;
        }
    }
}

