/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney;

import io.honeycomb.libhoney.shaded.org.apache.http.HttpHost;
import io.honeycomb.libhoney.shaded.org.apache.http.client.CredentialsProvider;
import io.honeycomb.libhoney.utils.Assert;
import io.honeycomb.libhoney.utils.ObjectUtils;
import javax.net.ssl.SSLContext;

public class TransportOptions {
    public static final int DEFAULT_BATCH_SIZE = 50;
    public static final long DEFAULT_BATCH_TIMEOUT = 100L;
    public static final int DEFAULT_QUEUE_CAPACITY = 10000;
    public static final int DEFAULT_MAX_PENDING_BATCH_REQUESTS = 250;
    public static final int DEFAULT_MAX_CONNECTIONS = 200;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_API_HOST = 100;
    public static final int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 10000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 3000;
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_IO_THREAD_COUNT = Runtime.getRuntime().availableProcessors();
    public static final long DEFAULT_MAX_HTTP_REQUEST_SHUTDOWN_WAIT = 2000L;
    public static final String DEFAULT_ADDITIONAL_USER_AGENT = "";
    private final int batchSize;
    private final long batchTimeoutMillis;
    private final int queueCapacity;
    private final int maxPendingBatchRequests;
    private final int maxConnections;
    private final int maxConnectionsPerApiHost;
    private final int connectTimeout;
    private final int connectionRequestTimeout;
    private final int socketTimeout;
    private final int bufferSize;
    private final int ioThreadCount;
    private final long maximumHttpRequestShutdownWait;
    private final String additionalUserAgent;
    private final HttpHost proxy;
    private final SSLContext sslContext;
    private final CredentialsProvider credentialsProvider;

    TransportOptions(Integer batchSize, Long batchTimeoutMillis, Integer queueCapacity, Integer maxPendingBatchRequests, Integer maxConnections, Integer maxConnectionsPerApiHost, Integer connectTimeout, Integer connectionRequestTimeout, Integer socketTimeout, Integer bufferSize, Integer ioThreadCount, Long maximumHttpRequestShutdownWait, String additionalUserAgent, HttpHost proxy, SSLContext sslContext, CredentialsProvider credentialsProvider) {
        this.batchSize = ObjectUtils.getOrDefault(batchSize, 50);
        this.batchTimeoutMillis = ObjectUtils.getOrDefault(batchTimeoutMillis, 100L);
        this.queueCapacity = ObjectUtils.getOrDefault(queueCapacity, 10000);
        this.maxPendingBatchRequests = ObjectUtils.getOrDefault(maxPendingBatchRequests, 250);
        this.maxConnections = ObjectUtils.getOrDefault(maxConnections, 200);
        this.maxConnectionsPerApiHost = ObjectUtils.getOrDefault(maxConnectionsPerApiHost, 100);
        this.connectTimeout = ObjectUtils.getOrDefault(connectTimeout, 10000);
        this.connectionRequestTimeout = ObjectUtils.getOrDefault(connectionRequestTimeout, 10000);
        this.socketTimeout = ObjectUtils.getOrDefault(socketTimeout, 3000);
        this.bufferSize = ObjectUtils.getOrDefault(bufferSize, 8192);
        this.ioThreadCount = ObjectUtils.getOrDefault(ioThreadCount, DEFAULT_IO_THREAD_COUNT);
        this.maximumHttpRequestShutdownWait = ObjectUtils.getOrDefault(maximumHttpRequestShutdownWait, 2000L);
        this.additionalUserAgent = ObjectUtils.getOrDefault(additionalUserAgent, DEFAULT_ADDITIONAL_USER_AGENT);
        this.proxy = proxy;
        this.sslContext = sslContext;
        this.credentialsProvider = credentialsProvider;
        Assert.isTrue(this.batchSize >= 1, "batchSize must be 1 or greater");
        Assert.isTrue(this.batchTimeoutMillis >= 1L, "batchTimeoutMillis must be 1 or greater");
        Assert.isTrue(this.queueCapacity >= 1, "queueCapacity must be 1 or greater");
        Assert.isFalse(this.maxPendingBatchRequests == 0, "maxPendingBatchRequests must not be 0");
        Assert.isFalse(this.maxPendingBatchRequests < -1, "maxPendingBatchRequests must not be less than -1");
        Assert.isTrue(this.maxConnections >= 1, "maxConnections must be 1 or greater");
        Assert.isTrue(this.maxConnectionsPerApiHost >= 1, "maxConnectionsPerApiHost must be 1 or greater");
        Assert.isTrue(this.bufferSize >= 1024, "bufferSize must be 1024 or greater");
        Assert.isTrue(this.ioThreadCount >= 1 && this.ioThreadCount <= Runtime.getRuntime().availableProcessors(), "ioThreadCount must be at least 1 and at most the number of available CPU cores");
        Assert.isTrue(this.maximumHttpRequestShutdownWait > 0L, "maximumHttpRequestShutdownWait must be positive");
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getBatchTimeoutMillis() {
        return this.batchTimeoutMillis;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getMaxPendingBatchRequests() {
        return this.maxPendingBatchRequests;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxHttpConnectionsPerApiHost() {
        return this.maxConnectionsPerApiHost;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getIoThreadCount() {
        return this.ioThreadCount;
    }

    public long getMaximumHttpRequestShutdownWait() {
        return this.maximumHttpRequestShutdownWait;
    }

    public String getAdditionalUserAgent() {
        return this.additionalUserAgent;
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "TransportOptions{batchSize=" + this.batchSize + ", batchTimeoutMillis=" + this.batchTimeoutMillis + ", queueCapacity=" + this.queueCapacity + ", maxPendingBatchRequests=" + this.maxPendingBatchRequests + ", maxConnections=" + this.maxConnections + ", maxConnectionsPerApiHost=" + this.maxConnectionsPerApiHost + ", connectTimeout=" + this.connectTimeout + ", connectionRequestTimeout=" + this.connectionRequestTimeout + ", socketTimeout=" + this.socketTimeout + ", bufferSize=" + this.bufferSize + ", ioThreadCount=" + this.ioThreadCount + ", maximumHttpRequestShutdownWait=" + this.maximumHttpRequestShutdownWait + ", additionalUserAgent=" + this.additionalUserAgent + '}';
    }

    public static class Builder {
        private Integer batchSize;
        private Long batchTimeoutMillis;
        private Integer queueCapacity;
        private Integer maximumPendingBatchRequests;
        private Integer maxConnections;
        private Integer maxConnectionsPerApiHost;
        private Integer connectTimeout;
        private Integer connectionRequestTimeout;
        private Integer socketTimeout;
        private Integer bufferSize;
        private Integer ioThreadCount;
        private Long maximumHttpRequestShutdownWait;
        private String additionalUserAgent;
        private HttpHost proxy;
        private SSLContext sslContext;
        private CredentialsProvider credentialsProvider;

        public TransportOptions build() {
            return new TransportOptions(this.batchSize, this.batchTimeoutMillis, this.queueCapacity, this.maximumPendingBatchRequests, this.maxConnections, this.maxConnectionsPerApiHost, this.connectTimeout, this.connectionRequestTimeout, this.socketTimeout, this.bufferSize, this.ioThreadCount, this.maximumHttpRequestShutdownWait, this.additionalUserAgent, this.proxy, this.sslContext, this.credentialsProvider);
        }

        public Integer getBatchSize() {
            return this.batchSize;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Long getBatchTimeoutMillis() {
            return this.batchTimeoutMillis;
        }

        public Builder setBatchTimeoutMillis(long batchTimeoutMillis) {
            this.batchTimeoutMillis = batchTimeoutMillis;
            return this;
        }

        public Integer getQueueCapacity() {
            return this.queueCapacity;
        }

        public Builder setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Integer getMaximumPendingBatchRequests() {
            return this.maximumPendingBatchRequests;
        }

        public Builder setMaximumPendingBatchRequests(int maximumPendingBatchRequests) {
            this.maximumPendingBatchRequests = maximumPendingBatchRequests;
            return this;
        }

        public int getMaxConnections() {
            return this.maxConnections;
        }

        public Builder setMaxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public int getMaxConnectionsPerApiHost() {
            return this.maxConnectionsPerApiHost;
        }

        public Builder setMaxConnectionsPerApiHost(int maxConnectionsPerApiHost) {
            this.maxConnectionsPerApiHost = maxConnectionsPerApiHost;
            return this;
        }

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public Builder setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public int getConnectionRequestTimeout() {
            return this.connectionRequestTimeout;
        }

        public Builder setConnectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public int getSocketTimeout() {
            return this.socketTimeout;
        }

        public Builder setSocketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public Builder setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Integer getIoThreadCount() {
            return this.ioThreadCount;
        }

        public Builder setIoThreadCount(int ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Long getMaximumHttpRequestShutdownWait() {
            return this.maximumHttpRequestShutdownWait;
        }

        public Builder setMaximumHttpRequestShutdownWait(long maximumHttpRequestShutdownWait) {
            this.maximumHttpRequestShutdownWait = maximumHttpRequestShutdownWait;
            return this;
        }

        public String getAdditionalUserAgent() {
            return this.additionalUserAgent;
        }

        public Builder setAdditionalUserAgent(String additionalUserAgent) {
            this.additionalUserAgent = additionalUserAgent;
            return this;
        }

        public HttpHost getProxy() {
            return this.proxy;
        }

        public Builder setProxy(HttpHost proxy) {
            this.proxy = proxy;
            return this;
        }

        public SSLContext getSSLContext() {
            return this.sslContext;
        }

        public Builder setSSLContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }
    }
}

