/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.builders;

import io.honeycomb.libhoney.DefaultDebugResponseObserver;
import io.honeycomb.libhoney.EventPostProcessor;
import io.honeycomb.libhoney.HoneyClient;
import io.honeycomb.libhoney.Options;
import io.honeycomb.libhoney.ResponseObserver;
import io.honeycomb.libhoney.TransportOptions;
import io.honeycomb.libhoney.ValueSupplier;
import io.honeycomb.libhoney.shaded.org.apache.http.HttpHost;
import io.honeycomb.libhoney.shaded.org.apache.http.auth.AuthScope;
import io.honeycomb.libhoney.shaded.org.apache.http.auth.Credentials;
import io.honeycomb.libhoney.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import io.honeycomb.libhoney.shaded.org.apache.http.client.CredentialsProvider;
import io.honeycomb.libhoney.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import io.honeycomb.libhoney.transport.Transport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class HoneyClientBuilder {
    private final Map<String, Object> globalFields = new HashMap<String, Object>();
    private final Map<String, ValueSupplier<?>> globalDynamicFields = new HashMap();
    private final Map<String, Credentials> credentialMap = new HashMap<String, Credentials>();
    private final List<ResponseObserver> responseObservers = new ArrayList<ResponseObserver>();
    protected TransportOptions.Builder transportOptionsBuilder = new TransportOptions.Builder();
    protected Options.Builder optionsBuilder = new Options.Builder();
    private Transport transport = null;
    private boolean debugEnabled = false;

    public HoneyClient build() {
        this.configureOptionBuilder();
        this.configureTransportOptionBuilder();
        HoneyClient client = this.createClient();
        this.configureClient(client);
        return client;
    }

    private HoneyClient createClient() {
        if (this.transport == null) {
            return new HoneyClient(this.optionsBuilder.build(), this.transportOptionsBuilder.build());
        }
        return new HoneyClient(this.optionsBuilder.build(), this.transport);
    }

    private void configureClient(HoneyClient client) {
        if (!this.responseObservers.isEmpty()) {
            for (ResponseObserver responseObserver : this.responseObservers) {
                client.addResponseObserver(responseObserver);
            }
        }
        if (this.debugEnabled) {
            client.addResponseObserver(new DefaultDebugResponseObserver());
        }
    }

    private void configureTransportOptionBuilder() {
        if (!this.credentialMap.isEmpty()) {
            this.transportOptionsBuilder.setCredentialsProvider(this.createCredentialsProvider());
        }
    }

    private CredentialsProvider createCredentialsProvider() {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        for (Map.Entry<String, Credentials> entry : this.credentialMap.entrySet()) {
            String proxy = entry.getKey();
            Credentials credential = entry.getValue();
            HttpHost proxyHost = HttpHost.create(proxy);
            AuthScope authScope = new AuthScope(proxyHost);
            provider.setCredentials(authScope, credential);
        }
        return provider;
    }

    private void configureOptionBuilder() {
        if (!this.globalFields.isEmpty()) {
            this.optionsBuilder.setGlobalFields(this.globalFields);
        }
        if (!this.globalDynamicFields.isEmpty()) {
            this.optionsBuilder.setGlobalDynamicFields(this.globalDynamicFields);
        }
    }

    public HoneyClientBuilder addGlobalField(String name, Object field) {
        this.globalFields.put(name, field);
        return this;
    }

    public HoneyClientBuilder addGlobalDynamicFields(String name, ValueSupplier<?> valueSupplier) {
        this.globalDynamicFields.put(name, valueSupplier);
        return this;
    }

    public HoneyClientBuilder addProxy(String proxyHost, String username, String password) {
        UsernamePasswordCredentials credential = new UsernamePasswordCredentials(username, password);
        this.credentialMap.put(proxyHost, credential);
        return this;
    }

    public HoneyClientBuilder sampleRate(int sampleRate) {
        this.optionsBuilder.setSampleRate(sampleRate);
        return this;
    }

    public HoneyClientBuilder eventPostProcessor(EventPostProcessor eventPostProcessor) {
        this.optionsBuilder.setEventPostProcessor(eventPostProcessor);
        return this;
    }

    public HoneyClientBuilder batchSize(int batchSize) {
        this.transportOptionsBuilder.setBatchSize(batchSize);
        return this;
    }

    public HoneyClientBuilder batchTimeoutMillis(long batchTimeoutMillis) {
        this.transportOptionsBuilder.setBatchTimeoutMillis(batchTimeoutMillis);
        return this;
    }

    public HoneyClientBuilder queueCapacity(int queueCapacity) {
        this.transportOptionsBuilder.setQueueCapacity(queueCapacity);
        return this;
    }

    public HoneyClientBuilder maxPendingBatchRequests(int maxPendingBatchRequests) {
        this.transportOptionsBuilder.setMaximumPendingBatchRequests(maxPendingBatchRequests);
        return this;
    }

    public HoneyClientBuilder maxConnections(int maxConnections) {
        this.transportOptionsBuilder.setMaxConnections(maxConnections);
        return this;
    }

    public HoneyClientBuilder maxConnectionsPerApiHost(int maxConnectionsPerApiHost) {
        this.transportOptionsBuilder.setMaxConnectionsPerApiHost(maxConnectionsPerApiHost);
        return this;
    }

    public HoneyClientBuilder connectionTimeout(int connectTimeout) {
        this.transportOptionsBuilder.setConnectTimeout(connectTimeout);
        return this;
    }

    public HoneyClientBuilder connectionRequestTimeout(int connectionRequestTimeout) {
        this.transportOptionsBuilder.setConnectionRequestTimeout(connectionRequestTimeout);
        return this;
    }

    public HoneyClientBuilder socketTimeout(int socketTimeout) {
        this.transportOptionsBuilder.setSocketTimeout(socketTimeout);
        return this;
    }

    public HoneyClientBuilder bufferSize(int bufferSize) {
        this.transportOptionsBuilder.setBufferSize(bufferSize);
        return this;
    }

    public HoneyClientBuilder ioThreadCount(int ioThreadCount) {
        this.transportOptionsBuilder.setIoThreadCount(ioThreadCount);
        return this;
    }

    public HoneyClientBuilder maximumHttpRequestShutdownWait(long maximumHttpRequestShutdownWait) {
        this.transportOptionsBuilder.setMaximumHttpRequestShutdownWait(maximumHttpRequestShutdownWait);
        return this;
    }

    public HoneyClientBuilder additionalUserAgent(String additionalUserAgent) {
        this.transportOptionsBuilder.setAdditionalUserAgent(additionalUserAgent);
        return this;
    }

    public HoneyClientBuilder addProxy(String host) {
        this.transportOptionsBuilder.setProxy(new HttpHost(host));
        return this;
    }

    public HoneyClientBuilder sslContext(SSLContext sslContext) {
        this.transportOptionsBuilder.setSSLContext(sslContext);
        return this;
    }

    public HoneyClientBuilder dataSet(String dataSet) {
        this.optionsBuilder.setDataset(dataSet);
        return this;
    }

    public HoneyClientBuilder apiHost(String apiHost) throws URISyntaxException {
        this.apiHost(new URI(apiHost));
        return this;
    }

    public HoneyClientBuilder apiHost(URI apiHost) throws URISyntaxException {
        this.optionsBuilder.setApiHost(apiHost);
        return this;
    }

    public HoneyClientBuilder writeKey(String writeKey) {
        this.optionsBuilder.setWriteKey(writeKey);
        return this;
    }

    public HoneyClientBuilder debug(boolean enabled) {
        this.debugEnabled = enabled;
        return this;
    }

    public HoneyClientBuilder addResponseObserver(ResponseObserver responseObserver) {
        this.responseObservers.add(responseObserver);
        return this;
    }

    public HoneyClientBuilder transport(Transport transport) {
        this.transport = transport;
        return this;
    }
}

