/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.eventdata;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public abstract class EventData<T extends EventData<T>> {
    private final Map<String, Object> fields;
    private URI apiHost;
    private String writeKey;
    private String dataset;
    private int sampleRate;
    private Long timestamp;
    private Map<String, Object> metadata;

    protected EventData(URI apiHost, String writeKey, String dataset, int sampleRate, Long timestamp, Map<String, Object> fields, Map<String, Object> metadata) {
        this.apiHost = apiHost;
        this.writeKey = writeKey;
        this.dataset = dataset;
        this.sampleRate = sampleRate;
        this.timestamp = timestamp;
        this.metadata = metadata == null ? new HashMap() : metadata;
        this.fields = new HashMap<String, Object>(fields);
    }

    protected abstract T getSelf();

    protected T setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
        return this.getSelf();
    }

    public T setApiHost(URI apiHost) {
        this.apiHost = apiHost;
        return this.getSelf();
    }

    public T setWriteKey(String writeKey) {
        this.writeKey = writeKey;
        return this.getSelf();
    }

    public T setDataset(String dataset) {
        this.dataset = dataset;
        return this.getSelf();
    }

    public T setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this.getSelf();
    }

    public T addField(String fieldKey, Object fieldValue) {
        this.fields.put(fieldKey, fieldValue);
        return this.getSelf();
    }

    public T addFields(Map<String, ?> fields) {
        this.fields.putAll(fields);
        return this.getSelf();
    }

    public T addMetadata(String metadataKey, Object metadataValue) {
        this.metadata.put(metadataKey, metadataValue);
        return this.getSelf();
    }

    public T addMetadata(Map<String, ?> metadata) {
        this.metadata.putAll(metadata);
        return this.getSelf();
    }

    public URI getApiHost() {
        return this.apiHost;
    }

    public String getWriteKey() {
        return this.writeKey;
    }

    public String getDataset() {
        return this.dataset;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, Object> getMetadata() {
        if (this.metadata == null) {
            this.metadata = new HashMap<String, Object>();
        }
        return this.metadata;
    }

    public String toString() {
        return "EventData{fields=" + this.fields + ", apiHost=" + this.apiHost + ", writeKey=**********, dataset='" + this.dataset + '\'' + ", sampleRate=" + this.sampleRate + ", timestamp=" + this.timestamp + ", metadata=" + this.metadata + '}';
    }
}

