/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.responses;

import io.honeycomb.libhoney.ResponseObserver;
import io.honeycomb.libhoney.responses.ClientRejected;
import io.honeycomb.libhoney.responses.ServerAccepted;
import io.honeycomb.libhoney.responses.ServerRejected;
import io.honeycomb.libhoney.responses.Unknown;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseObservable
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseObservable.class);
    private final CopyOnWriteArrayList<ResponseObserver> observers = new CopyOnWriteArrayList();

    public void publish(ServerAccepted toPublish) {
        for (ResponseObserver observer : this.observers) {
            observer.onServerAccepted(toPublish);
        }
    }

    public void publish(ServerRejected toPublish) {
        for (ResponseObserver observer : this.observers) {
            observer.onServerRejected(toPublish);
        }
    }

    public void publish(ClientRejected toPublish) {
        for (ResponseObserver observer : this.observers) {
            observer.onClientRejected(toPublish);
        }
    }

    public void publish(Unknown toPublish) {
        for (ResponseObserver listener : this.observers) {
            listener.onUnknown(toPublish);
        }
    }

    public void add(ResponseObserver observer) {
        this.observers.add(observer);
        LOG.info("Added observer: {}", (Object)observer);
    }

    public void remove(ResponseObserver observer) {
        if (this.observers.remove(observer)) {
            LOG.info("Removed observer: {}", (Object)observer);
        } else {
            LOG.info("Observer not present in observer list: {}", (Object)observer);
        }
    }

    public boolean hasObservers() {
        return !this.observers.isEmpty();
    }

    @Override
    public void close() {
        this.observers.clear();
    }
}

