/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.responses.impl;

import io.honeycomb.libhoney.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import io.honeycomb.libhoney.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import io.honeycomb.libhoney.shaded.com.fasterxml.jackson.databind.ObjectReader;
import io.honeycomb.libhoney.utils.JsonUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class BatchResponseBody {
    public static final int BATCH_ACCEPTED_STATUS_CODE = 200;
    public static final int BATCH_ELEMENT_SUCCESS_CODE = 202;
    private static final ObjectReader BATCH_RESPONSE_ELEMENTS_READER = JsonUtils.OBJECT_MAPPER.readerFor(BatchResponseElement[].class);
    private static final ObjectReader BATCH_ERROR_RESPONSE_READER = JsonUtils.OBJECT_MAPPER.readerFor(BatchErrorResponse.class);
    private final List<BatchResponseElement> batchResponseElements;
    private final BatchErrorResponse batchErrorResponse;
    private final ServerApiError serverApiError;
    private final ServerResponseCategory category;

    BatchResponseBody(byte[] rawHttpResponseBody, int httpCode) {
        ServerResponseCategory tempCategory;
        ServerApiError tempServerApiError;
        BatchErrorResponse tempError;
        List<Object> tempElements;
        if (httpCode == 200) {
            try {
                tempElements = Arrays.asList((Object[])BATCH_RESPONSE_ELEMENTS_READER.readValue(rawHttpResponseBody));
                tempError = null;
                tempServerApiError = null;
                tempCategory = ServerResponseCategory.BATCH_ACCEPTED;
            }
            catch (IOException e) {
                tempElements = null;
                tempError = null;
                tempServerApiError = new ServerApiError("Failed to parse batch response elements from response", e);
                tempCategory = ServerResponseCategory.CANNOT_INFER_STATE;
            }
        } else {
            try {
                tempElements = null;
                tempError = (BatchErrorResponse)BATCH_ERROR_RESPONSE_READER.readValue(rawHttpResponseBody);
                tempServerApiError = null;
                tempCategory = ServerResponseCategory.BATCH_REJECTED;
            }
            catch (IOException e) {
                tempElements = null;
                tempError = null;
                String body = new String(rawHttpResponseBody);
                tempServerApiError = new ServerApiError("Failed to parse batch error response from response. Raw response: ```" + body + "```", e);
                tempCategory = ServerResponseCategory.CANNOT_INFER_STATE;
            }
        }
        this.batchErrorResponse = tempError;
        this.batchResponseElements = tempElements;
        this.serverApiError = tempServerApiError;
        this.category = tempCategory;
    }

    ServerResponseCategory getCategory() {
        return this.category;
    }

    BatchErrorResponse getBatchError() {
        return this.batchErrorResponse;
    }

    List<BatchResponseElement> getBatchResponseElements() {
        return this.batchResponseElements;
    }

    ServerApiError getServerApiError() {
        return this.serverApiError;
    }

    static enum ServerResponseCategory {
        BATCH_ACCEPTED,
        BATCH_REJECTED,
        CANNOT_INFER_STATE;

    }

    static class ServerApiError {
        private final String message;
        private final IOException cause;

        ServerApiError(String message, IOException cause) {
            this.message = message;
            this.cause = cause;
        }

        String getMessage() {
            return this.message;
        }

        IOException getCause() {
            return this.cause;
        }

        public String toString() {
            return "ServerApiError{message='" + this.message + '\'' + ", cause=" + this.cause + '}';
        }
    }

    static class BatchErrorResponse {
        private final String error;

        BatchErrorResponse(@JsonProperty(value="error") String error) {
            this.error = error;
        }

        String getError() {
            return this.error;
        }

        @JsonIgnore
        public String toString() {
            return "BatchErrorResponse{error='" + this.error + '\'' + '}';
        }
    }

    static class BatchResponseElement {
        private final int status;
        private final String error;

        BatchResponseElement(@JsonProperty(value="status") int status, @JsonProperty(value="error") String error) {
            this.status = status;
            this.error = error;
        }

        @JsonIgnore
        boolean isAccepted() {
            return this.status == 202;
        }

        int getStatus() {
            return this.status;
        }

        String getError() {
            return this.error;
        }

        @JsonIgnore
        public String toString() {
            return "BatchResponseElement{status=" + this.status + ", error='" + this.error + '\'' + '}';
        }
    }
}

