/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.responses.impl;

import io.honeycomb.libhoney.Event;
import io.honeycomb.libhoney.Metrics;
import io.honeycomb.libhoney.eventdata.ResolvedEvent;
import io.honeycomb.libhoney.responses.ClientRejected;
import io.honeycomb.libhoney.responses.Unknown;
import io.honeycomb.libhoney.responses.impl.SimpleClientRejected;
import io.honeycomb.libhoney.responses.impl.SimpleUnknown;
import java.util.Map;

public final class EventResponseFactory {
    private EventResponseFactory() {
    }

    public static Unknown httpClientError(ResolvedEvent event, String message, Exception exception) {
        return new SimpleUnknown(Unknown.ReasonType.HTTP_CLIENT_ERROR, event.getMetadata(), event.getMetrics(), message, exception);
    }

    public static ClientRejected queueOverflow(ResolvedEvent event) {
        return new ClientRejectedBuilder(ClientRejected.RejectionReason.QUEUE_OVERFLOW, "Queue capacity reached").setEventMetadata(event.getMetadata()).setMetrics(event.getMetrics()).build();
    }

    public static ClientRejected notSampled(Event event) {
        return new ClientRejectedBuilder(ClientRejected.RejectionReason.NOT_SAMPLED, "Event sample rate was: " + event.getSampleRate()).setEventMetadata(event.getMetadata()).setMetrics(Metrics.create()).build();
    }

    public static ClientRejected requestBuildFailure(ResolvedEvent event, Exception exception) {
        return new ClientRejectedBuilder(ClientRejected.RejectionReason.REQUEST_BUILD_FAILURE, "Http client failure while assembling HTTP request due to exception: " + exception.getMessage()).setException(exception).setEventMetadata(event.getMetadata()).setMetrics(event.getMetrics()).build();
    }

    public static ClientRejected dynamicFieldResolutionError(Event event, Exception exception) {
        return new ClientRejectedBuilder(ClientRejected.RejectionReason.DYNAMIC_FIELD_RESOLUTION_ERROR, "Dynamic field resolution failed due to unexpected exception: " + exception.getMessage()).setException(exception).setEventMetadata(event.getMetadata()).setMetrics(Metrics.create()).build();
    }

    public static ClientRejected postProcessorError(ResolvedEvent event, Exception exception) {
        return new ClientRejectedBuilder(ClientRejected.RejectionReason.POST_PROCESSING_ERROR, "Post processing failed due to unexpected exception: " + exception.getMessage()).setException(exception).setMetrics(event.getMetrics()).setEventMetadata(event.getMetadata()).build();
    }

    public static class ClientRejectedBuilder {
        private final ClientRejected.RejectionReason reason;
        private final String message;
        private Map<String, Object> eventMetadata;
        private Metrics metrics;
        private Exception exception;

        public ClientRejectedBuilder(ClientRejected.RejectionReason reason, String message) {
            this.reason = reason;
            this.message = message;
        }

        public SimpleClientRejected build() {
            this.metrics = this.metrics == null ? Metrics.create() : this.metrics;
            return new SimpleClientRejected(this.reason, this.exception, this.message, this.eventMetadata, this.metrics);
        }

        public ClientRejectedBuilder setEventMetadata(Map<String, Object> eventMetadata) {
            this.eventMetadata = eventMetadata;
            return this;
        }

        public ClientRejectedBuilder setMetrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public ClientRejectedBuilder setException(Exception exception) {
            this.exception = exception;
            return this;
        }
    }
}

