/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.responses.impl;

import io.honeycomb.libhoney.Metrics;
import io.honeycomb.libhoney.eventdata.ResolvedEvent;
import io.honeycomb.libhoney.responses.ResponseObservable;
import io.honeycomb.libhoney.responses.ServerResponse;
import io.honeycomb.libhoney.responses.Unknown;
import io.honeycomb.libhoney.responses.impl.BatchResponseBody;
import io.honeycomb.libhoney.responses.impl.SimpleBatchData;
import io.honeycomb.libhoney.responses.impl.SimpleServerAccepted;
import io.honeycomb.libhoney.responses.impl.SimpleServerRejected;
import io.honeycomb.libhoney.responses.impl.SimpleUnknown;
import io.honeycomb.libhoney.utils.Assert;
import io.honeycomb.libhoney.utils.Lazy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LazyServerResponse {
    public static final String EVENT_ACCEPTED_MESSAGE = "ACCEPTED";
    private final byte[] rawHttpResponseBody;
    private final Map<String, Object> eventMetadata;
    private final Lazy<BatchResponseBody> lazyBody;
    private final Metrics metrics;
    private final ServerResponse.BatchData batchData;

    LazyServerResponse(int batchStatusCode, byte[] rawHttpResponseBody, Map<String, Object> eventMetadata, LazyResponseBody lazyBody, int batchPosition, Metrics metrics) {
        this.rawHttpResponseBody = rawHttpResponseBody;
        this.eventMetadata = eventMetadata;
        this.lazyBody = lazyBody;
        this.metrics = metrics;
        this.batchData = new SimpleBatchData(batchPosition, batchStatusCode);
    }

    public void publishTo(ResponseObservable observable) {
        BatchResponseBody batchResponseBody = this.lazyBody.get();
        switch (batchResponseBody.getCategory()) {
            case BATCH_ACCEPTED: {
                BatchResponseBody.BatchResponseElement element = this.assertBatchElements(batchResponseBody);
                if (element.isAccepted()) {
                    SimpleServerAccepted accepted = new SimpleServerAccepted(this.rawHttpResponseBody, this.eventMetadata, this.metrics, this.batchData, element.getStatus(), EVENT_ACCEPTED_MESSAGE);
                    observable.publish(accepted);
                    break;
                }
                String elementMessage = element.getError();
                SimpleServerRejected rejected = new SimpleServerRejected(this.rawHttpResponseBody, this.eventMetadata, this.metrics, this.batchData, element.getStatus(), elementMessage);
                observable.publish(rejected);
                break;
            }
            case BATCH_REJECTED: {
                String batchMessage = batchResponseBody.getBatchError().getError();
                SimpleServerRejected rejected = new SimpleServerRejected(this.rawHttpResponseBody, this.eventMetadata, this.metrics, this.batchData, -1, batchMessage);
                observable.publish(rejected);
                break;
            }
            case CANNOT_INFER_STATE: {
                String message = batchResponseBody.getServerApiError().getMessage();
                IOException cause = batchResponseBody.getServerApiError().getCause();
                SimpleUnknown unknown = new SimpleUnknown(Unknown.ReasonType.SERVER_API_ERROR, this.eventMetadata, this.metrics, message, cause);
                observable.publish(unknown);
                break;
            }
            default: {
                throw new IllegalStateException("Switch not exhaustive");
            }
        }
    }

    private BatchResponseBody.BatchResponseElement assertBatchElements(BatchResponseBody batchResponseBody) {
        List<BatchResponseBody.BatchResponseElement> batchResponseElements = batchResponseBody.getBatchResponseElements();
        Assert.state(batchResponseElements != null, "Event data requested, but elements array is null");
        Assert.state(this.batchData.getPositionInBatch() < batchResponseElements.size(), "This event's index in the batch exceeds the batch response's size");
        return batchResponseElements.get(this.batchData.getPositionInBatch());
    }

    public static List<LazyServerResponse> createEventsWithServerResponse(List<ResolvedEvent> events, byte[] rawHttpResponseBody, int httpCode) {
        ArrayList<LazyServerResponse> lazyResponses = new ArrayList<LazyServerResponse>(events.size());
        LazyResponseBody lazyResponseBody = new LazyResponseBody(rawHttpResponseBody, httpCode);
        for (int i = 0; i < events.size(); ++i) {
            ResolvedEvent event = events.get(i);
            lazyResponses.add(new LazyServerResponse(httpCode, rawHttpResponseBody, event.getMetadata(), lazyResponseBody, i, event.getMetrics()));
        }
        return lazyResponses;
    }

    static class LazyResponseBody
    extends Lazy<BatchResponseBody> {
        private final byte[] rawHttpResponseBody;
        private final int httpCode;

        LazyResponseBody(byte[] rawHttpResponseBody, int httpCode) {
            this.rawHttpResponseBody = rawHttpResponseBody;
            this.httpCode = httpCode;
        }

        @Override
        protected BatchResponseBody init() {
            return new BatchResponseBody(this.rawHttpResponseBody, this.httpCode);
        }
    }
}

