/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.shaded.org.apache.http.impl.pool;

import io.honeycomb.libhoney.shaded.org.apache.http.HttpClientConnection;
import io.honeycomb.libhoney.shaded.org.apache.http.HttpHost;
import io.honeycomb.libhoney.shaded.org.apache.http.annotation.Contract;
import io.honeycomb.libhoney.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.honeycomb.libhoney.shaded.org.apache.http.config.ConnectionConfig;
import io.honeycomb.libhoney.shaded.org.apache.http.config.SocketConfig;
import io.honeycomb.libhoney.shaded.org.apache.http.impl.pool.BasicConnFactory;
import io.honeycomb.libhoney.shaded.org.apache.http.impl.pool.BasicPoolEntry;
import io.honeycomb.libhoney.shaded.org.apache.http.params.HttpParams;
import io.honeycomb.libhoney.shaded.org.apache.http.pool.AbstractConnPool;
import io.honeycomb.libhoney.shaded.org.apache.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicConnPool
extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();

    public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
        super(connFactory, 2, 20);
    }

    @Deprecated
    public BasicConnPool(HttpParams params) {
        super(new BasicConnFactory(params), 2, 20);
    }

    public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
        super(new BasicConnFactory(sconfig, cconfig), 2, 20);
    }

    public BasicConnPool() {
        super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
    }

    @Override
    protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
        return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
    }

    @Override
    protected boolean validate(BasicPoolEntry entry) {
        return !((HttpClientConnection)entry.getConnection()).isStale();
    }
}

