/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.transport.impl;

import io.honeycomb.libhoney.TransportOptions;
import io.honeycomb.libhoney.eventdata.ResolvedEvent;
import io.honeycomb.libhoney.responses.ResponseObservable;
import io.honeycomb.libhoney.shaded.org.apache.http.client.config.RequestConfig;
import io.honeycomb.libhoney.shaded.org.apache.http.config.ConnectionConfig;
import io.honeycomb.libhoney.shaded.org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import io.honeycomb.libhoney.shaded.org.apache.http.impl.nio.client.HttpAsyncClients;
import io.honeycomb.libhoney.shaded.org.apache.http.impl.nio.reactor.IOReactorConfig;
import io.honeycomb.libhoney.transport.Transport;
import io.honeycomb.libhoney.transport.batch.BatchConsumer;
import io.honeycomb.libhoney.transport.batch.Batcher;
import io.honeycomb.libhoney.transport.batch.ClockProvider;
import io.honeycomb.libhoney.transport.batch.impl.DefaultBatcher;
import io.honeycomb.libhoney.transport.batch.impl.HoneycombBatchConsumer;
import io.honeycomb.libhoney.transport.batch.impl.HoneycombBatchKeyStrategy;
import io.honeycomb.libhoney.transport.batch.impl.SystemClockProvider;
import io.honeycomb.libhoney.transport.json.BatchRequestSerializer;
import io.honeycomb.libhoney.transport.json.JsonSerializer;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchingHttpTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(BatchingHttpTransport.class);
    private final Batcher<ResolvedEvent> batcher;
    private final BatchConsumer<ResolvedEvent> consumer;
    private final ResponseObservable responseObservable;

    public BatchingHttpTransport(Batcher<ResolvedEvent> batcher, BatchConsumer<ResolvedEvent> consumer, ResponseObservable responseObservable) {
        this.batcher = batcher;
        this.consumer = consumer;
        this.responseObservable = responseObservable;
    }

    @Override
    public boolean submit(ResolvedEvent event) {
        event.markEnqueueTime();
        return this.batcher.offerEvent(event);
    }

    @Override
    public ResponseObservable getResponseObservable() {
        return this.responseObservable;
    }

    @Override
    public void close() throws Exception {
        LOG.debug("Close called on BatchingHTTPTransport. Closing batcher.");
        this.batcher.close();
        LOG.debug("Closing BatchConsumer.");
        this.consumer.close();
        LOG.debug("Closing ResponseObservers and ResponseObservable");
        this.responseObservable.close();
        LOG.debug("Finished close");
    }

    public static BatchingHttpTransport init(TransportOptions options) {
        return BatchingHttpTransport.init(options, new BatchRequestSerializer());
    }

    public static BatchingHttpTransport init(TransportOptions options, JsonSerializer<List<HoneycombBatchConsumer.BatchRequestElement>> batchRequestSerializer) {
        ResponseObservable responseObservable = new ResponseObservable();
        CloseableHttpAsyncClient httpAsyncClient = BatchingHttpTransport.buildClient(options);
        httpAsyncClient.start();
        HoneycombBatchKeyStrategy batchKeyStrategy = new HoneycombBatchKeyStrategy();
        ClockProvider systemClockProvider = SystemClockProvider.getInstance();
        HoneycombBatchConsumer honeycombBatchConsumer = new HoneycombBatchConsumer(httpAsyncClient, responseObservable, batchRequestSerializer, options.getMaxPendingBatchRequests(), options.getMaximumHttpRequestShutdownWait(), options.getAdditionalUserAgent());
        DefaultBatcher<ResolvedEvent, String> batcher = new DefaultBatcher<ResolvedEvent, String>(batchKeyStrategy, honeycombBatchConsumer, systemClockProvider, new ArrayBlockingQueue(options.getQueueCapacity()), options.getBatchSize(), options.getBatchTimeoutMillis());
        return new BatchingHttpTransport(batcher, honeycombBatchConsumer, responseObservable);
    }

    public static CloseableHttpAsyncClient buildClient(TransportOptions options) {
        return HttpAsyncClients.custom().setMaxConnTotal(options.getMaxConnections()).setMaxConnPerRoute(options.getMaxHttpConnectionsPerApiHost()).setConnectionManagerShared(false).setSSLContext(options.getSSLContext()).setDefaultRequestConfig(RequestConfig.custom().setProxy(options.getProxy()).setConnectTimeout(options.getConnectTimeout()).setConnectionRequestTimeout(options.getConnectionRequestTimeout()).setSocketTimeout(options.getSocketTimeout()).build()).setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(options.getIoThreadCount()).build()).setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(options.getBufferSize()).build()).setDefaultCredentialsProvider(options.getCredentialsProvider()).build();
    }
}

