/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.transport.impl;

import io.honeycomb.libhoney.Metrics;
import io.honeycomb.libhoney.eventdata.ResolvedEvent;
import io.honeycomb.libhoney.responses.ClientRejected;
import io.honeycomb.libhoney.responses.ResponseObservable;
import io.honeycomb.libhoney.transport.Transport;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleTransport
implements Transport {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleTransport.class);
    private final ResponseObservable observable;

    public ConsoleTransport(ResponseObservable observable) {
        this.observable = observable;
    }

    @Override
    public boolean submit(ResolvedEvent event) {
        LOG.info("Submitting event to dead-end: {}", (Object)event);
        this.observable.publish(new ConsoleTransportDeadEnd(event));
        return true;
    }

    @Override
    public ResponseObservable getResponseObservable() {
        return this.observable;
    }

    @Override
    public void close() {
        LOG.info("ConsoleTransport: Closed!");
    }

    private static class ConsoleTransportDeadEnd
    implements ClientRejected {
        private final ResolvedEvent event;

        public ConsoleTransportDeadEnd(ResolvedEvent event) {
            this.event = event;
        }

        @Override
        public ClientRejected.RejectionReason getReason() {
            return ClientRejected.RejectionReason.DEAD_END;
        }

        @Override
        public Exception getException() {
            return null;
        }

        @Override
        public Map<String, Object> getEventMetadata() {
            return this.event.getMetadata();
        }

        @Override
        public Metrics getMetrics() {
            return this.event.getMetrics();
        }

        @Override
        public String getMessage() {
            return "ConsoleTransport";
        }
    }
}

