/*
 * Decompiled with CFR 0.152.
 */
package io.honeycomb.libhoney.utils;

import io.honeycomb.libhoney.utils.ObjectUtils;
import java.util.Map;

public final class Assert {
    private Assert() {
    }

    public static void isTrue(boolean test, String msg) {
        if (!test) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isFalse(boolean test, String msg) {
        if (test) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T> void notNull(T object, String msg) {
        if (object == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void state(boolean test, String msg) {
        if (!test) {
            throw new IllegalStateException(msg);
        }
    }

    public static void notEmpty(String test, String msg) {
        if (ObjectUtils.isNullOrEmpty(test)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void notEmpty(Map<?, ?> test, String msg) {
        if (test == null || test.isEmpty()) {
            throw new IllegalArgumentException(msg);
        }
    }
}

