/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.kheos.lib;

import io.honnix.kheos.common.ChangeEvent;
import io.honnix.kheos.common.ChangeEventResponse;
import io.honnix.kheos.common.Command;
import io.honnix.kheos.common.CommandGroup;
import io.honnix.kheos.common.GroupedCommand;
import io.honnix.kheos.common.JSON;
import io.honnix.kheos.common.Message;
import io.honnix.kheos.common.RegisterForChangeEventsResponse;
import io.honnix.kheos.common.Result;
import io.honnix.kheos.lib.ChangeEventListener;
import io.honnix.kheos.lib.HeosChangeEventsClient;
import io.honnix.kheos.lib.HeosChangeEventsClientImpl;
import io.honnix.kheos.lib.HeosClientKt;
import io.honnix.kheos.lib.HeosCommandException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0010H\u0016R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/honnix/kheos/lib/HeosChangeEventsClientImpl;", "Lio/honnix/kheos/lib/HeosChangeEventsClient;", "host", "", "socketFactory", "Lkotlin/Function0;", "Ljava/net/Socket;", "socketExecutorService", "Ljava/util/concurrent/ExecutorService;", "listenerExecutorService", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Ljava/util/concurrent/ExecutorService;Ljava/util/concurrent/ExecutorService;)V", "clientSocket", "id", "Ljava/util/concurrent/atomic/AtomicInteger;", "listeners", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/honnix/kheos/lib/ChangeEventListener;", "close", "", "connect", "register", "listener", "registerForChangeEvents", "unregister", "Companion", "kheos-lib"})
public final class HeosChangeEventsClientImpl
implements HeosChangeEventsClient {
    private final AtomicInteger id;
    private Socket clientSocket;
    private final ConcurrentHashMap<Integer, ChangeEventListener> listeners;
    private final Function0<Socket> socketFactory;
    private final ExecutorService socketExecutorService;
    private final ExecutorService listenerExecutorService;
    private static final Logger logger;
    public static final Companion Companion;

    private final void registerForChangeEvents() {
        HeosChangeEventsClientImpl.Companion.getLogger().info("register for change events");
        Socket socket = this.clientSocket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientSocket");
        }
        PrintWriter output = new PrintWriter(socket.getOutputStream(), true);
        Socket socket2 = this.clientSocket;
        if (socket2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientSocket");
        }
        BufferedReader input = new BufferedReader(new InputStreamReader(socket2.getInputStream()));
        output.printf("" + HeosClientKt.mkCommand(new GroupedCommand(CommandGroup.SYSTEM, Command.REGISTER_FOR_CHANGE_EVENTS), new Message.Builder().add("enable", "on").build()) + "\r\n", new Object[0]);
        String rawResponse = input.readLine();
        HeosChangeEventsClientImpl.Companion.getLogger().debug(rawResponse);
        RegisterForChangeEventsResponse response = (RegisterForChangeEventsResponse)JSON.INSTANCE.getMapper().readValue(rawResponse, RegisterForChangeEventsResponse.class);
        if (response.getHeos().getResult() == Result.FAIL) {
            throw (Throwable)HeosCommandException.Companion.build(response.getHeos().getMessage());
        }
    }

    @Override
    public void connect() {
        this.clientSocket = (Socket)this.socketFactory.invoke();
        this.registerForChangeEvents();
        this.socketExecutorService.execute(new Runnable(this){
            final /* synthetic */ HeosChangeEventsClientImpl this$0;

            /*
             * Unable to fully structure code
             */
            public final void run() {
                block2: while (true) {
                    try {
                        input = new BufferedReader(new InputStreamReader(HeosChangeEventsClientImpl.access$getClientSocket$p(this.this$0).getInputStream()));
                        input = input.readLine();
                    }
                    catch (IOException e) {
                        if (e instanceof SocketException && Intrinsics.areEqual((Object)"Socket closed", (Object)e.getMessage())) break;
                        message = "failed to communicate with " + HeosChangeEventsClientImpl.access$getClientSocket$p(this.this$0).getInetAddress();
                        io.honnix.kheos.lib.HeosChangeEventsClientImpl$Companion.access$getLogger$p(HeosChangeEventsClientImpl.Companion).error(message);
                        v0 = HeosChangeEventsClientImpl.access$getListeners$p(this.this$0).values();
                        Intrinsics.checkExpressionValueIsNotNull(v0, (String)"listeners.values");
                        $receiver$iv = v0;
                        var6_7 = $receiver$iv.iterator();
                        while (true) {
                            if (!var6_7.hasNext()) continue block2;
                            element$iv = var6_7.next();
                            it = (ChangeEventListener)element$iv;
                            HeosChangeEventsClientImpl.access$getListenerExecutorService$p(this.this$0).execute(new Runnable(it, this, e){
                                final /* synthetic */ ChangeEventListener $it;
                                final /* synthetic */ connect.1 this$0;
                                final /* synthetic */ IOException $e$inlined;
                                {
                                    this.$it = changeEventListener;
                                    this.this$0 = var2_2;
                                    this.$e$inlined = iOException;
                                }

                                public final void run() {
                                    this.$it.onException(this.$e$inlined);
                                }
                            });
                        }
                    }
                    rawResponse = input;
                    io.honnix.kheos.lib.HeosChangeEventsClientImpl$Companion.access$getLogger$p(HeosChangeEventsClientImpl.Companion).debug((String)rawResponse);
                    changeEvent = ((ChangeEventResponse)JSON.INSTANCE.getMapper().readValue((String)rawResponse, ChangeEventResponse.class)).getEvent();
                    v1 = HeosChangeEventsClientImpl.access$getListeners$p(this.this$0).values();
                    Intrinsics.checkExpressionValueIsNotNull(v1, (String)"listeners.values");
                    $receiver$iv = v1;
                    var4_5 = $receiver$iv.iterator();
                    while (true) {
                        if (var4_5.hasNext()) ** break;
                        continue block2;
                        element$iv = var4_5.next();
                        it = (ChangeEventListener)element$iv;
                        HeosChangeEventsClientImpl.access$getListenerExecutorService$p(this.this$0).execute(new Runnable(it, this, changeEvent){
                            final /* synthetic */ ChangeEventListener $it;
                            final /* synthetic */ connect.1 this$0;
                            final /* synthetic */ ChangeEvent $changeEvent$inlined;
                            {
                                this.$it = changeEventListener;
                                this.this$0 = var2_2;
                                this.$changeEvent$inlined = changeEvent;
                            }

                            public final void run() {
                                this.$it.onEvent(this.$changeEvent$inlined);
                            }
                        });
                    }
                    break;
                }
            }
            {
                this.this$0 = heosChangeEventsClientImpl;
            }
        });
    }

    @Override
    public int register(@NotNull ChangeEventListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        int newId = this.id.getAndIncrement();
        Map map = this.listeners;
        Integer n = newId;
        ChangeEventListener changeEventListener = listener;
        map.put(n, changeEventListener);
        return newId;
    }

    @Override
    public void unregister(int id) {
        MapsKt.minus((Map)this.listeners, (Object)id);
    }

    @Override
    public void close() {
        HeosChangeEventsClientImpl.Companion.getLogger().info("closing connection to heos");
        Socket socket = this.clientSocket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientSocket");
        }
        socket.close();
        this.socketExecutorService.shutdownNow();
        this.listenerExecutorService.shutdown();
    }

    public HeosChangeEventsClientImpl(@NotNull String host, @NotNull Function0<? extends Socket> socketFactory, @NotNull ExecutorService socketExecutorService, @NotNull ExecutorService listenerExecutorService) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull(socketFactory, (String)"socketFactory");
        Intrinsics.checkParameterIsNotNull((Object)socketExecutorService, (String)"socketExecutorService");
        Intrinsics.checkParameterIsNotNull((Object)listenerExecutorService, (String)"listenerExecutorService");
        this.socketFactory = socketFactory;
        this.socketExecutorService = socketExecutorService;
        this.listenerExecutorService = listenerExecutorService;
        this.id = new AtomicInteger();
        this.listeners = new ConcurrentHashMap();
    }

    public /* synthetic */ HeosChangeEventsClientImpl(final String string, Function0 function0, ExecutorService executorService, ExecutorService executorService2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = (Function0)new Function0<Socket>(){

                @NotNull
                public final Socket invoke() {
                    return new Socket(string, 1255);
                }
            };
        }
        if ((n & 4) != 0) {
            ExecutorService executorService3 = Executors.newSingleThreadExecutor();
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService3, (String)"Executors.newSingleThreadExecutor()");
            executorService = executorService3;
        }
        if ((n & 8) != 0) {
            ExecutorService executorService4 = Executors.newFixedThreadPool(4);
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService4, (String)"Executors.newFixedThreadPool(4)");
            executorService2 = executorService4;
        }
        this(string, (Function0<? extends Socket>)function0, executorService, executorService2);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(HeosChangeEventsClientImpl.class);
    }

    @NotNull
    public static final /* synthetic */ Socket access$getClientSocket$p(HeosChangeEventsClientImpl $this) {
        Socket socket = $this.clientSocket;
        if (socket == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clientSocket");
        }
        return socket;
    }

    public static final /* synthetic */ void access$setClientSocket$p(HeosChangeEventsClientImpl $this, @NotNull Socket socket) {
        $this.clientSocket = socket;
    }

    @NotNull
    public static final /* synthetic */ ConcurrentHashMap access$getListeners$p(HeosChangeEventsClientImpl $this) {
        return $this.listeners;
    }

    @NotNull
    public static final /* synthetic */ ExecutorService access$getListenerExecutorService$p(HeosChangeEventsClientImpl $this) {
        return $this.listenerExecutorService;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/honnix/kheos/lib/HeosChangeEventsClientImpl$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "kheos-lib"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

