/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.kheos.lib;

import java.io.Closeable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.UpnpServiceImpl;
import org.fourthline.cling.controlpoint.ControlPoint;
import org.fourthline.cling.model.message.header.DeviceTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.RemoteDevice;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.registry.DefaultRegistryListener;
import org.fourthline.cling.registry.Registry;
import org.fourthline.cling.registry.RegistryListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\u0005H\u0016J\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/honnix/kheos/lib/HeosDiscovery;", "Ljava/io/Closeable;", "callback", "Lkotlin/Function1;", "Lorg/fourthline/cling/model/meta/RemoteDevice;", "", "upnpService", "Lorg/fourthline/cling/UpnpService;", "(Lkotlin/jvm/functions/Function1;Lorg/fourthline/cling/UpnpService;)V", "close", "discover", "Companion", "HeosRegistryListener", "kheos-lib"})
public final class HeosDiscovery
implements Closeable {
    private final Function1<RemoteDevice, Unit> callback;
    private final UpnpService upnpService;
    private static final Logger logger;
    @NotNull
    private static final DeviceType deviceType;
    public static final Companion Companion;

    public final void discover() {
        HeosDiscovery.Companion.getLogger().info("registering device listener");
        ControlPoint controlPoint = this.upnpService.getControlPoint();
        Intrinsics.checkExpressionValueIsNotNull((Object)controlPoint, (String)"upnpService.controlPoint");
        controlPoint.getRegistry().addListener((RegistryListener)new HeosRegistryListener(this.callback));
        HeosDiscovery.Companion.getLogger().info("searching device type " + Companion.getDeviceType$kheos_lib());
        this.upnpService.getControlPoint().search((UpnpHeader)new DeviceTypeHeader(Companion.getDeviceType$kheos_lib()));
    }

    @Override
    public void close() {
        HeosDiscovery.Companion.getLogger().info("shutting down UPnP service");
        this.upnpService.shutdown();
    }

    public HeosDiscovery(@NotNull Function1<? super RemoteDevice, Unit> callback, @NotNull UpnpService upnpService) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        Intrinsics.checkParameterIsNotNull((Object)upnpService, (String)"upnpService");
        this.callback = callback;
        this.upnpService = upnpService;
    }

    public /* synthetic */ HeosDiscovery(Function1 function1, UpnpService upnpService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            upnpService = (UpnpService)new UpnpServiceImpl();
        }
        this((Function1<? super RemoteDevice, Unit>)function1, upnpService);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(HeosDiscovery.class);
        deviceType = new DeviceType("schemas-denon-com", "ACT-Denon", 1);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/honnix/kheos/lib/HeosDiscovery$HeosRegistryListener;", "Lorg/fourthline/cling/registry/DefaultRegistryListener;", "callback", "Lkotlin/Function1;", "Lorg/fourthline/cling/model/meta/RemoteDevice;", "", "(Lkotlin/jvm/functions/Function1;)V", "remoteDeviceAdded", "registry", "Lorg/fourthline/cling/registry/Registry;", "device", "kheos-lib"})
    public static final class HeosRegistryListener
    extends DefaultRegistryListener {
        private final Function1<RemoteDevice, Unit> callback;

        public void remoteDeviceAdded(@NotNull Registry registry, @NotNull RemoteDevice device) {
            Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
            Intrinsics.checkParameterIsNotNull((Object)device, (String)"device");
            if (Intrinsics.areEqual((Object)device.getType(), (Object)Companion.getDeviceType$kheos_lib())) {
                Companion.getLogger().debug("HOES device discovered" + device.getDisplayString());
                this.callback.invoke((Object)device);
            }
        }

        public HeosRegistryListener(@NotNull Function1<? super RemoteDevice, Unit> callback) {
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.callback = callback;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/honnix/kheos/lib/HeosDiscovery$Companion;", "", "()V", "deviceType", "Lorg/fourthline/cling/model/types/DeviceType;", "getDeviceType$kheos_lib", "()Lorg/fourthline/cling/model/types/DeviceType;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "kheos-lib"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final DeviceType getDeviceType$kheos_lib() {
            return deviceType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

