/*-
 * -\-\-
 * rkt-launcher
 * --
 * 
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */
package io.honnix.rkt.launcher;

import io.honnix.rkt.launcher.options.GlobalOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;

/**
 * Configurations passed to {@link RktLauncher}.
 */
@AutoMatter
public interface RktLauncherConfig {

  /**
   * The path to rkt executable. By default {@link RktLauncher} uses <code>rkt</code>.
   *
   * @return the path to rkt executable
   */
  Optional<String> rkt();

  /**
   * The daemon command prefix.
   * By default {@link RktLauncher uses <code>[systemd-run, --slice=machine]</code>}
   *
   * @return the daemon command prefix
   */
  Optional<List<String>> daemon();

  /**
   * Global options. <code>rkt -h</code> will give a list of available global options.
   *
   * @return the global options
   */
  Optional<GlobalOptions> globalOptions();

  static RktLauncherConfigBuilder builder() {
    return new RktLauncherConfigBuilder();
  }
}
