package io.honnix.rkt.launcher;

import io.honnix.rkt.launcher.options.GlobalOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class RktLauncherConfigBuilder {
  private Optional<String> rkt;

  private Optional<List<String>> daemon;

  private Optional<GlobalOptions> globalOptions;

  public RktLauncherConfigBuilder() {
    this.rkt = Optional.empty();
    this.daemon = Optional.empty();
    this.globalOptions = Optional.empty();
  }

  private RktLauncherConfigBuilder(RktLauncherConfig v) {
    this.rkt = v.rkt();
    this.daemon = v.daemon();
    this.globalOptions = v.globalOptions();
  }

  private RktLauncherConfigBuilder(RktLauncherConfigBuilder v) {
    this.rkt = v.rkt;
    this.daemon = v.daemon;
    this.globalOptions = v.globalOptions;
  }

  public Optional<String> rkt() {
    return rkt;
  }

  public RktLauncherConfigBuilder rkt(String rkt) {
    return rkt(Optional.ofNullable(rkt));
  }

  @SuppressWarnings("unchecked")
  public RktLauncherConfigBuilder rkt(Optional<? extends String> rkt) {
    if (rkt == null) {
      throw new NullPointerException("rkt");
    }
    this.rkt = (Optional<String>)rkt;
    return this;
  }

  public Optional<List<String>> daemon() {
    return daemon;
  }

  public RktLauncherConfigBuilder daemon(List<String> daemon) {
    return daemon(Optional.ofNullable(daemon));
  }

  @SuppressWarnings("unchecked")
  public RktLauncherConfigBuilder daemon(Optional<? extends List<String>> daemon) {
    if (daemon == null) {
      throw new NullPointerException("daemon");
    }
    this.daemon = (Optional<List<String>>)daemon;
    return this;
  }

  public Optional<GlobalOptions> globalOptions() {
    return globalOptions;
  }

  public RktLauncherConfigBuilder globalOptions(GlobalOptions globalOptions) {
    return globalOptions(Optional.ofNullable(globalOptions));
  }

  @SuppressWarnings("unchecked")
  public RktLauncherConfigBuilder globalOptions(Optional<? extends GlobalOptions> globalOptions) {
    if (globalOptions == null) {
      throw new NullPointerException("globalOptions");
    }
    this.globalOptions = (Optional<GlobalOptions>)globalOptions;
    return this;
  }

  public RktLauncherConfig build() {
    return new Value(rkt, daemon, globalOptions);
  }

  public static RktLauncherConfigBuilder from(RktLauncherConfig v) {
    return new RktLauncherConfigBuilder(v);
  }

  public static RktLauncherConfigBuilder from(RktLauncherConfigBuilder v) {
    return new RktLauncherConfigBuilder(v);
  }

  private static final class Value implements RktLauncherConfig {
    private final Optional<String> rkt;

    private final Optional<List<String>> daemon;

    private final Optional<GlobalOptions> globalOptions;

    private Value(@AutoMatter.Field("rkt") Optional<String> rkt, @AutoMatter.Field("daemon") Optional<List<String>> daemon, @AutoMatter.Field("globalOptions") Optional<GlobalOptions> globalOptions) {
      if (rkt == null) {
        throw new NullPointerException("rkt");
      }
      if (daemon == null) {
        throw new NullPointerException("daemon");
      }
      if (globalOptions == null) {
        throw new NullPointerException("globalOptions");
      }
      this.rkt = rkt;
      this.daemon = daemon;
      this.globalOptions = globalOptions;
    }

    @AutoMatter.Field
    @Override
    public Optional<String> rkt() {
      return rkt;
    }

    @AutoMatter.Field
    @Override
    public Optional<List<String>> daemon() {
      return daemon;
    }

    @AutoMatter.Field
    @Override
    public Optional<GlobalOptions> globalOptions() {
      return globalOptions;
    }

    public RktLauncherConfigBuilder builder() {
      return new RktLauncherConfigBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof RktLauncherConfig)) {
        return false;
      }
      final RktLauncherConfig that = (RktLauncherConfig) o;
      if (rkt != null ? !rkt.equals(that.rkt()) : that.rkt() != null) {
        return false;
      }
      if (daemon != null ? !daemon.equals(that.daemon()) : that.daemon() != null) {
        return false;
      }
      if (globalOptions != null ? !globalOptions.equals(that.globalOptions()) : that.globalOptions() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (rkt != null ? rkt.hashCode() : 0);
      result = 31 * result + (daemon != null ? daemon.hashCode() : 0);
      result = 31 * result + (globalOptions != null ? globalOptions.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "RktLauncherConfig{" +
      "rkt=" + rkt +
      ", daemon=" + daemon +
      ", globalOptions=" + globalOptions +
      '}';
    }
  }
}
