package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.options.CatManifestOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class CatManifestBuilder {
  private Optional<CatManifestOptions> options;

  private Optional<List<String>> args;

  public CatManifestBuilder() {
    this.options = Optional.empty();
    this.args = Optional.empty();
  }

  private CatManifestBuilder(CatManifest v) {
    this.options = v.options();
    this.args = v.args();
  }

  private CatManifestBuilder(CatManifestBuilder v) {
    this.options = v.options;
    this.args = v.args;
  }

  public Optional<CatManifestOptions> options() {
    return options;
  }

  public CatManifestBuilder options(CatManifestOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public CatManifestBuilder options(Optional<? extends CatManifestOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<CatManifestOptions>)options;
    return this;
  }

  public Optional<List<String>> args() {
    return args;
  }

  public CatManifestBuilder args(List<String> args) {
    return args(Optional.ofNullable(args));
  }

  @SuppressWarnings("unchecked")
  public CatManifestBuilder args(Optional<? extends List<String>> args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    this.args = (Optional<List<String>>)args;
    return this;
  }

  public CatManifest build() {
    return new Value(options, args);
  }

  public static CatManifestBuilder from(CatManifest v) {
    return new CatManifestBuilder(v);
  }

  public static CatManifestBuilder from(CatManifestBuilder v) {
    return new CatManifestBuilder(v);
  }

  private static final class Value implements CatManifest {
    private final Optional<CatManifestOptions> options;

    private final Optional<List<String>> args;

    private Value(@AutoMatter.Field("options") Optional<CatManifestOptions> options, @AutoMatter.Field("args") Optional<List<String>> args) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      if (args == null) {
        throw new NullPointerException("args");
      }
      this.options = options;
      this.args = args;
    }

    @AutoMatter.Field
    @Override
    public Optional<CatManifestOptions> options() {
      return options;
    }

    @AutoMatter.Field
    @Override
    public Optional<List<String>> args() {
      return args;
    }

    public CatManifestBuilder builder() {
      return new CatManifestBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof CatManifest)) {
        return false;
      }
      final CatManifest that = (CatManifest) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      if (args != null ? !args.equals(that.args()) : that.args() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      result = 31 * result + (args != null ? args.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "CatManifest{" +
      "options=" + options +
      ", args=" + args +
      '}';
    }
  }
}
