package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.options.PrepareOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class PrepareBuilder {
  private Optional<PrepareOptions> options;

  public PrepareBuilder() {
    this.options = Optional.empty();
  }

  private PrepareBuilder(Prepare v) {
    this.options = v.options();
  }

  private PrepareBuilder(PrepareBuilder v) {
    this.options = v.options;
  }

  public Optional<PrepareOptions> options() {
    return options;
  }

  public PrepareBuilder options(PrepareOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public PrepareBuilder options(Optional<? extends PrepareOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<PrepareOptions>)options;
    return this;
  }

  public Prepare build() {
    return new Value(options);
  }

  public static PrepareBuilder from(Prepare v) {
    return new PrepareBuilder(v);
  }

  public static PrepareBuilder from(PrepareBuilder v) {
    return new PrepareBuilder(v);
  }

  private static final class Value implements Prepare {
    private final Optional<PrepareOptions> options;

    private Value(@AutoMatter.Field("options") Optional<PrepareOptions> options) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      this.options = options;
    }

    @AutoMatter.Field
    @Override
    public Optional<PrepareOptions> options() {
      return options;
    }

    public PrepareBuilder builder() {
      return new PrepareBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Prepare)) {
        return false;
      }
      final Prepare that = (Prepare) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Prepare{" +
      "options=" + options +
      '}';
    }
  }
}
