package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.options.RmOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class RmBuilder {
  private Optional<RmOptions> options;

  private Optional<List<String>> args;

  public RmBuilder() {
    this.options = Optional.empty();
    this.args = Optional.empty();
  }

  private RmBuilder(Rm v) {
    this.options = v.options();
    this.args = v.args();
  }

  private RmBuilder(RmBuilder v) {
    this.options = v.options;
    this.args = v.args;
  }

  public Optional<RmOptions> options() {
    return options;
  }

  public RmBuilder options(RmOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public RmBuilder options(Optional<? extends RmOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<RmOptions>)options;
    return this;
  }

  public Optional<List<String>> args() {
    return args;
  }

  public RmBuilder args(List<String> args) {
    return args(Optional.ofNullable(args));
  }

  @SuppressWarnings("unchecked")
  public RmBuilder args(Optional<? extends List<String>> args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    this.args = (Optional<List<String>>)args;
    return this;
  }

  public Rm build() {
    return new Value(options, args);
  }

  public static RmBuilder from(Rm v) {
    return new RmBuilder(v);
  }

  public static RmBuilder from(RmBuilder v) {
    return new RmBuilder(v);
  }

  private static final class Value implements Rm {
    private final Optional<RmOptions> options;

    private final Optional<List<String>> args;

    private Value(@AutoMatter.Field("options") Optional<RmOptions> options, @AutoMatter.Field("args") Optional<List<String>> args) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      if (args == null) {
        throw new NullPointerException("args");
      }
      this.options = options;
      this.args = args;
    }

    @AutoMatter.Field
    @Override
    public Optional<RmOptions> options() {
      return options;
    }

    @AutoMatter.Field
    @Override
    public Optional<List<String>> args() {
      return args;
    }

    public RmBuilder builder() {
      return new RmBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Rm)) {
        return false;
      }
      final Rm that = (Rm) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      if (args != null ? !args.equals(that.args()) : that.args() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      result = 31 * result + (args != null ? args.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Rm{" +
      "options=" + options +
      ", args=" + args +
      '}';
    }
  }
}
