package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.options.RunOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class RunBuilder {
  private boolean daemonize;

  private Optional<RunOptions> options;

  public RunBuilder() {
    this.options = Optional.empty();
  }

  private RunBuilder(Run v) {
    this.daemonize = v.daemonize();
    this.options = v.options();
  }

  private RunBuilder(RunBuilder v) {
    this.daemonize = v.daemonize;
    this.options = v.options;
  }

  public boolean daemonize() {
    return daemonize;
  }

  public RunBuilder daemonize(boolean daemonize) {
    this.daemonize = daemonize;
    return this;
  }

  public Optional<RunOptions> options() {
    return options;
  }

  public RunBuilder options(RunOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public RunBuilder options(Optional<? extends RunOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<RunOptions>)options;
    return this;
  }

  public Run build() {
    return new Value(daemonize, options);
  }

  public static RunBuilder from(Run v) {
    return new RunBuilder(v);
  }

  public static RunBuilder from(RunBuilder v) {
    return new RunBuilder(v);
  }

  private static final class Value implements Run {
    private final boolean daemonize;

    private final Optional<RunOptions> options;

    private Value(@AutoMatter.Field("daemonize") boolean daemonize, @AutoMatter.Field("options") Optional<RunOptions> options) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      this.daemonize = daemonize;
      this.options = options;
    }

    @AutoMatter.Field
    @Override
    public boolean daemonize() {
      return daemonize;
    }

    @AutoMatter.Field
    @Override
    public Optional<RunOptions> options() {
      return options;
    }

    public RunBuilder builder() {
      return new RunBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Run)) {
        return false;
      }
      final Run that = (Run) o;
      if (daemonize != that.daemonize()) {
        return false;
      }
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (daemonize ? 1231 : 1237);
      result = 31 * result + (options != null ? options.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Run{" +
      "daemonize=" + daemonize +
      ", options=" + options +
      '}';
    }
  }
}
