package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.options.StatusOptions;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class StatusBuilder {
  private Optional<StatusOptions> options;

  private List<String> args;

  public StatusBuilder() {
    this.options = Optional.empty();
  }

  private StatusBuilder(Status v) {
    this.options = v.options();
    List<? extends String> _args = v.args();
    this.args = (_args == null) ? null : new ArrayList<String>(_args);
  }

  private StatusBuilder(StatusBuilder v) {
    this.options = v.options;
    this.args = (v.args == null) ? null : new ArrayList<String>(v.args);
  }

  public Optional<StatusOptions> options() {
    return options;
  }

  public StatusBuilder options(StatusOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public StatusBuilder options(Optional<? extends StatusOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<StatusOptions>)options;
    return this;
  }

  public List<String> args() {
    if (this.args == null) {
      this.args = new ArrayList<String>();
    }
    return args;
  }

  public StatusBuilder args(List<? extends String> args) {
    return args((Collection<? extends String>) args);
  }

  public StatusBuilder args(Collection<? extends String> args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    for (String item : args) {
      if (item == null) {
        throw new NullPointerException("args: null item");
      }
    }
    this.args = new ArrayList<String>(args);
    return this;
  }

  public StatusBuilder args(Iterable<? extends String> args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    if (args instanceof Collection) {
      return args((Collection<? extends String>) args);
    }
    return args(args.iterator());
  }

  public StatusBuilder args(Iterator<? extends String> args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    this.args = new ArrayList<String>();
    while (args.hasNext()) {
      String item = args.next();
      if (item == null) {
        throw new NullPointerException("args: null item");
      }
      this.args.add(item);
    }
    return this;
  }

  @SafeVarargs
  public final StatusBuilder args(String... args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    return args(Arrays.asList(args));
  }

  public StatusBuilder addArg(String arg) {
    if (arg == null) {
      throw new NullPointerException("arg");
    }
    if (this.args == null) {
      this.args = new ArrayList<String>();
    }
    args.add(arg);
    return this;
  }

  public Status build() {
    List<String> _args = (args != null) ? Collections.unmodifiableList(new ArrayList<String>(args)) : Collections.<String>emptyList();
    return new Value(options, _args);
  }

  public static StatusBuilder from(Status v) {
    return new StatusBuilder(v);
  }

  public static StatusBuilder from(StatusBuilder v) {
    return new StatusBuilder(v);
  }

  private static final class Value implements Status {
    private final Optional<StatusOptions> options;

    private final List<String> args;

    private Value(@AutoMatter.Field("options") Optional<StatusOptions> options, @AutoMatter.Field("args") List<String> args) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      this.options = options;
      this.args = (args != null) ? args : Collections.<String>emptyList();
    }

    @AutoMatter.Field
    @Override
    public Optional<StatusOptions> options() {
      return options;
    }

    @AutoMatter.Field
    @Override
    public List<String> args() {
      return args;
    }

    public StatusBuilder builder() {
      return new StatusBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Status)) {
        return false;
      }
      final Status that = (Status) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      if (args != null ? !args.equals(that.args()) : that.args() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      result = 31 * result + (args != null ? args.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Status{" +
      "options=" + options +
      ", args=" + args +
      '}';
    }
  }
}
