package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.options.TrustOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class TrustBuilder {
  private Optional<TrustOptions> options;

  private Optional<List<String>> args;

  public TrustBuilder() {
    this.options = Optional.empty();
    this.args = Optional.empty();
  }

  private TrustBuilder(Trust v) {
    this.options = v.options();
    this.args = v.args();
  }

  private TrustBuilder(TrustBuilder v) {
    this.options = v.options;
    this.args = v.args;
  }

  public Optional<TrustOptions> options() {
    return options;
  }

  public TrustBuilder options(TrustOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public TrustBuilder options(Optional<? extends TrustOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<TrustOptions>)options;
    return this;
  }

  public Optional<List<String>> args() {
    return args;
  }

  public TrustBuilder args(List<String> args) {
    return args(Optional.ofNullable(args));
  }

  @SuppressWarnings("unchecked")
  public TrustBuilder args(Optional<? extends List<String>> args) {
    if (args == null) {
      throw new NullPointerException("args");
    }
    this.args = (Optional<List<String>>)args;
    return this;
  }

  public Trust build() {
    return new Value(options, args);
  }

  public static TrustBuilder from(Trust v) {
    return new TrustBuilder(v);
  }

  public static TrustBuilder from(TrustBuilder v) {
    return new TrustBuilder(v);
  }

  private static final class Value implements Trust {
    private final Optional<TrustOptions> options;

    private final Optional<List<String>> args;

    private Value(@AutoMatter.Field("options") Optional<TrustOptions> options, @AutoMatter.Field("args") Optional<List<String>> args) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      if (args == null) {
        throw new NullPointerException("args");
      }
      this.options = options;
      this.args = args;
    }

    @AutoMatter.Field
    @Override
    public Optional<TrustOptions> options() {
      return options;
    }

    @AutoMatter.Field
    @Override
    public Optional<List<String>> args() {
      return args;
    }

    public TrustBuilder builder() {
      return new TrustBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Trust)) {
        return false;
      }
      final Trust that = (Trust) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      if (args != null ? !args.equals(that.args()) : that.args() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      result = 31 * result + (args != null ? args.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Trust{" +
      "options=" + options +
      ", args=" + args +
      '}';
    }
  }
}
