package io.honnix.rkt.launcher.command.image;

import io.honnix.rkt.launcher.options.image.GcOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class GcBuilder {
  private Optional<GcOptions> options;

  public GcBuilder() {
    this.options = Optional.empty();
  }

  private GcBuilder(Gc v) {
    this.options = v.options();
  }

  private GcBuilder(GcBuilder v) {
    this.options = v.options;
  }

  public Optional<GcOptions> options() {
    return options;
  }

  public GcBuilder options(GcOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public GcBuilder options(Optional<? extends GcOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<GcOptions>)options;
    return this;
  }

  public Gc build() {
    return new Value(options);
  }

  public static GcBuilder from(Gc v) {
    return new GcBuilder(v);
  }

  public static GcBuilder from(GcBuilder v) {
    return new GcBuilder(v);
  }

  private static final class Value implements Gc {
    private final Optional<GcOptions> options;

    private Value(@AutoMatter.Field("options") Optional<GcOptions> options) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      this.options = options;
    }

    @AutoMatter.Field
    @Override
    public Optional<GcOptions> options() {
      return options;
    }

    public GcBuilder builder() {
      return new GcBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof Gc)) {
        return false;
      }
      final Gc that = (Gc) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "Gc{" +
      "options=" + options +
      '}';
    }
  }
}
