package io.honnix.rkt.launcher.command.image;

import io.honnix.rkt.launcher.options.image.ListOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("io.norberg.automatter.processor.AutoMatterProcessor")
public final class ListBuilder {
  private Optional<ListOptions> options;

  public ListBuilder() {
    this.options = Optional.empty();
  }

  private ListBuilder(List v) {
    this.options = v.options();
  }

  private ListBuilder(ListBuilder v) {
    this.options = v.options;
  }

  public Optional<ListOptions> options() {
    return options;
  }

  public ListBuilder options(ListOptions options) {
    return options(Optional.ofNullable(options));
  }

  @SuppressWarnings("unchecked")
  public ListBuilder options(Optional<? extends ListOptions> options) {
    if (options == null) {
      throw new NullPointerException("options");
    }
    this.options = (Optional<ListOptions>)options;
    return this;
  }

  public List build() {
    return new Value(options);
  }

  public static ListBuilder from(List v) {
    return new ListBuilder(v);
  }

  public static ListBuilder from(ListBuilder v) {
    return new ListBuilder(v);
  }

  private static final class Value implements List {
    private final Optional<ListOptions> options;

    private Value(@AutoMatter.Field("options") Optional<ListOptions> options) {
      if (options == null) {
        throw new NullPointerException("options");
      }
      this.options = options;
    }

    @AutoMatter.Field
    @Override
    public Optional<ListOptions> options() {
      return options;
    }

    public ListBuilder builder() {
      return new ListBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (!(o instanceof List)) {
        return false;
      }
      final List that = (List) o;
      if (options != null ? !options.equals(that.options()) : that.options() != null) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      long temp;
      result = 31 * result + (options != null ? options.hashCode() : 0);
      return result;
    }

    @Override
    public String toString() {
      return "List{" +
      "options=" + options +
      '}';
    }
  }
}
