/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.honnix.rkt.launcher.RktLauncherConfig;
import io.honnix.rkt.launcher.command.Command;
import io.honnix.rkt.launcher.command.Daemonizable;
import io.honnix.rkt.launcher.exception.RktException;
import io.honnix.rkt.launcher.exception.RktLauncherException;
import io.honnix.rkt.launcher.options.Options;
import io.honnix.rkt.launcher.output.Output;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.zeroturnaround.exec.ProcessExecutor;

public class RktLauncher {
    private static final String DEFAULT_RKT = "rkt";
    private static final List<String> DEFAULT_DAEMON = ImmutableList.of((Object)"systemd-run", (Object)"--slice=machine");
    private static final Supplier<ProcessExecutor> DEFAULT_PROCESS_EXECUTOR_SUPPLIER = ProcessExecutor::new;
    private final RktLauncherConfig rktLauncherConfig;
    private final Supplier<ProcessExecutor> processExecutorSupplier;

    public RktLauncher(RktLauncherConfig rktLauncherConfig) {
        this(rktLauncherConfig, DEFAULT_PROCESS_EXECUTOR_SUPPLIER);
    }

    @VisibleForTesting
    RktLauncher(RktLauncherConfig rktLauncherConfig, Supplier<ProcessExecutor> processExecutorSupplier) {
        this.rktLauncherConfig = Objects.requireNonNull(rktLauncherConfig);
        this.processExecutorSupplier = Objects.requireNonNull(processExecutorSupplier);
    }

    public <T extends Options, S extends Output> S run(Command<T, S> command) throws RktLauncherException, RktException {
        ProcessExecutor processExecutor = this.processExecutorSupplier.get();
        processExecutor.readOutput(true);
        try {
            return command.parse(processExecutor.command(this.buildCompleteCommand(command)).executeNoTimeout());
        }
        catch (IOException | InterruptedException e) {
            throw new RktLauncherException("failed executing command " + command.getClass(), e);
        }
    }

    private <T extends Options, S extends Output> List<String> buildCompleteCommand(Command<T, S> command) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (command instanceof Daemonizable && ((Daemonizable)((Object)command)).daemonize()) {
            builder.addAll((Iterable)this.rktLauncherConfig.daemon().orElse(DEFAULT_DAEMON));
        }
        return builder.add((Object)this.rktLauncherConfig.rkt().orElse(DEFAULT_RKT)).addAll((Iterable)this.rktLauncherConfig.globalOptions().map(Options::asList).orElse((List)ImmutableList.of())).addAll(command.asList()).build();
    }
}

