/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher;

import io.honnix.rkt.launcher.RktLauncherConfig;
import io.honnix.rkt.launcher.options.GlobalOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;

public final class RktLauncherConfigBuilder {
    private Optional<String> rkt;
    private Optional<List<String>> daemon;
    private Optional<GlobalOptions> globalOptions;

    public RktLauncherConfigBuilder() {
        this.rkt = Optional.empty();
        this.daemon = Optional.empty();
        this.globalOptions = Optional.empty();
    }

    private RktLauncherConfigBuilder(RktLauncherConfig v) {
        this.rkt = v.rkt();
        this.daemon = v.daemon();
        this.globalOptions = v.globalOptions();
    }

    private RktLauncherConfigBuilder(RktLauncherConfigBuilder v) {
        this.rkt = v.rkt;
        this.daemon = v.daemon;
        this.globalOptions = v.globalOptions;
    }

    public Optional<String> rkt() {
        return this.rkt;
    }

    public RktLauncherConfigBuilder rkt(String rkt) {
        return this.rkt(Optional.ofNullable(rkt));
    }

    public RktLauncherConfigBuilder rkt(Optional<? extends String> rkt) {
        if (rkt == null) {
            throw new NullPointerException("rkt");
        }
        this.rkt = rkt;
        return this;
    }

    public Optional<List<String>> daemon() {
        return this.daemon;
    }

    public RktLauncherConfigBuilder daemon(List<String> daemon) {
        return this.daemon(Optional.ofNullable(daemon));
    }

    public RktLauncherConfigBuilder daemon(Optional<? extends List<String>> daemon) {
        if (daemon == null) {
            throw new NullPointerException("daemon");
        }
        this.daemon = daemon;
        return this;
    }

    public Optional<GlobalOptions> globalOptions() {
        return this.globalOptions;
    }

    public RktLauncherConfigBuilder globalOptions(GlobalOptions globalOptions) {
        return this.globalOptions(Optional.ofNullable(globalOptions));
    }

    public RktLauncherConfigBuilder globalOptions(Optional<? extends GlobalOptions> globalOptions) {
        if (globalOptions == null) {
            throw new NullPointerException("globalOptions");
        }
        this.globalOptions = globalOptions;
        return this;
    }

    public RktLauncherConfig build() {
        return new Value(this.rkt, this.daemon, this.globalOptions);
    }

    public static RktLauncherConfigBuilder from(RktLauncherConfig v) {
        return new RktLauncherConfigBuilder(v);
    }

    public static RktLauncherConfigBuilder from(RktLauncherConfigBuilder v) {
        return new RktLauncherConfigBuilder(v);
    }

    private static final class Value
    implements RktLauncherConfig {
        private final Optional<String> rkt;
        private final Optional<List<String>> daemon;
        private final Optional<GlobalOptions> globalOptions;

        private Value(@AutoMatter.Field(value="rkt") Optional<String> rkt, @AutoMatter.Field(value="daemon") Optional<List<String>> daemon, @AutoMatter.Field(value="globalOptions") Optional<GlobalOptions> globalOptions) {
            if (rkt == null) {
                throw new NullPointerException("rkt");
            }
            if (daemon == null) {
                throw new NullPointerException("daemon");
            }
            if (globalOptions == null) {
                throw new NullPointerException("globalOptions");
            }
            this.rkt = rkt;
            this.daemon = daemon;
            this.globalOptions = globalOptions;
        }

        @Override
        @AutoMatter.Field
        public Optional<String> rkt() {
            return this.rkt;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> daemon() {
            return this.daemon;
        }

        @Override
        @AutoMatter.Field
        public Optional<GlobalOptions> globalOptions() {
            return this.globalOptions;
        }

        @Override
        public RktLauncherConfigBuilder builder() {
            return new RktLauncherConfigBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RktLauncherConfig)) {
                return false;
            }
            RktLauncherConfig that = (RktLauncherConfig)o;
            if (this.rkt != null ? !this.rkt.equals(that.rkt()) : that.rkt() != null) {
                return false;
            }
            if (this.daemon != null ? !this.daemon.equals(that.daemon()) : that.daemon() != null) {
                return false;
            }
            return !(this.globalOptions != null ? !this.globalOptions.equals(that.globalOptions()) : that.globalOptions() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.rkt != null ? this.rkt.hashCode() : 0);
            result = 31 * result + (this.daemon != null ? this.daemon.hashCode() : 0);
            result = 31 * result + (this.globalOptions != null ? this.globalOptions.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "RktLauncherConfig{rkt=" + this.rkt + ", daemon=" + this.daemon + ", globalOptions=" + this.globalOptions + '}';
        }
    }
}

