/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.CatManifest;
import io.honnix.rkt.launcher.options.CatManifestOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;

public final class CatManifestBuilder {
    private Optional<CatManifestOptions> options;
    private Optional<List<String>> args;

    public CatManifestBuilder() {
        this.options = Optional.empty();
        this.args = Optional.empty();
    }

    private CatManifestBuilder(CatManifest v) {
        this.options = v.options();
        this.args = v.args();
    }

    private CatManifestBuilder(CatManifestBuilder v) {
        this.options = v.options;
        this.args = v.args;
    }

    public Optional<CatManifestOptions> options() {
        return this.options;
    }

    public CatManifestBuilder options(CatManifestOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public CatManifestBuilder options(Optional<? extends CatManifestOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public Optional<List<String>> args() {
        return this.args;
    }

    public CatManifestBuilder args(List<String> args) {
        return this.args(Optional.ofNullable(args));
    }

    public CatManifestBuilder args(Optional<? extends List<String>> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = args;
        return this;
    }

    public CatManifest build() {
        return new Value(this.options, this.args);
    }

    public static CatManifestBuilder from(CatManifest v) {
        return new CatManifestBuilder(v);
    }

    public static CatManifestBuilder from(CatManifestBuilder v) {
        return new CatManifestBuilder(v);
    }

    private static final class Value
    implements CatManifest {
        private final Optional<CatManifestOptions> options;
        private final Optional<List<String>> args;

        private Value(@AutoMatter.Field(value="options") Optional<CatManifestOptions> options, @AutoMatter.Field(value="args") Optional<List<String>> args) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            if (args == null) {
                throw new NullPointerException("args");
            }
            this.options = options;
            this.args = args;
        }

        @Override
        @AutoMatter.Field
        public Optional<CatManifestOptions> options() {
            return this.options;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> args() {
            return this.args;
        }

        @Override
        public CatManifestBuilder builder() {
            return new CatManifestBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CatManifest)) {
                return false;
            }
            CatManifest that = (CatManifest)o;
            if (this.options != null ? !this.options.equals(that.options()) : that.options() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CatManifest{options=" + this.options + ", args=" + this.args + '}';
        }
    }
}

