/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.CommandWithArgs;
import io.honnix.rkt.launcher.command.FetchBuilder;
import io.honnix.rkt.launcher.exception.RktUnexpectedOutputException;
import io.honnix.rkt.launcher.options.FetchOptions;
import io.honnix.rkt.launcher.output.FetchOutput;
import io.honnix.rkt.launcher.output.FetchOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Fetch
extends CommandWithArgs<FetchOptions, FetchOutput> {
    @Override
    public Optional<FetchOptions> options();

    @Override
    default public List<String> asList() {
        return this.asList("fetch");
    }

    @Override
    default public FetchOutput parse(String output) {
        Matcher hashMatcher;
        FetchOutputBuilder fetchOutputBuilder = FetchOutput.builder();
        Pattern signaturePattern = Pattern.compile("image: signature verified:\\s+(.+)");
        Pattern hashPattern = Pattern.compile("sha512-.+");
        Matcher signatureMatcher = signaturePattern.matcher(output);
        if (signatureMatcher.find()) {
            fetchOutputBuilder.signature(signatureMatcher.group(1));
        }
        if (!(hashMatcher = hashPattern.matcher(output)).find()) {
            throw new RktUnexpectedOutputException("no hash found");
        }
        fetchOutputBuilder.hash(hashMatcher.group());
        return fetchOutputBuilder.build();
    }

    public static FetchBuilder builder() {
        return new FetchBuilder();
    }
}

