/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Fetch;
import io.honnix.rkt.launcher.options.FetchOptions;
import io.norberg.automatter.AutoMatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public final class FetchBuilder {
    private Optional<FetchOptions> options;
    private List<String> args;

    public FetchBuilder() {
        this.options = Optional.empty();
    }

    private FetchBuilder(Fetch v) {
        this.options = v.options();
        List<String> _args = v.args();
        this.args = _args == null ? null : new ArrayList<String>(_args);
    }

    private FetchBuilder(FetchBuilder v) {
        this.options = v.options;
        this.args = v.args == null ? null : new ArrayList<String>(v.args);
    }

    public Optional<FetchOptions> options() {
        return this.options;
    }

    public FetchBuilder options(FetchOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public FetchBuilder options(Optional<? extends FetchOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public List<String> args() {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        return this.args;
    }

    public FetchBuilder args(List<? extends String> args) {
        return this.args((Collection<? extends String>)args);
    }

    public FetchBuilder args(Collection<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        for (String string : args) {
            if (string != null) continue;
            throw new NullPointerException("args: null item");
        }
        this.args = new ArrayList<String>(args);
        return this;
    }

    public FetchBuilder args(Iterable<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        if (args instanceof Collection) {
            return this.args((Collection)args);
        }
        return this.args(args.iterator());
    }

    public FetchBuilder args(Iterator<? extends String> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = new ArrayList<String>();
        while (args.hasNext()) {
            String item = args.next();
            if (item == null) {
                throw new NullPointerException("args: null item");
            }
            this.args.add(item);
        }
        return this;
    }

    @SafeVarargs
    public final FetchBuilder args(String ... args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        return this.args(Arrays.asList(args));
    }

    public FetchBuilder addArg(String arg) {
        if (arg == null) {
            throw new NullPointerException("arg");
        }
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(arg);
        return this;
    }

    public Fetch build() {
        List _args = this.args != null ? Collections.unmodifiableList(new ArrayList<String>(this.args)) : Collections.emptyList();
        return new Value(this.options, _args);
    }

    public static FetchBuilder from(Fetch v) {
        return new FetchBuilder(v);
    }

    public static FetchBuilder from(FetchBuilder v) {
        return new FetchBuilder(v);
    }

    private static final class Value
    implements Fetch {
        private final Optional<FetchOptions> options;
        private final List<String> args;

        private Value(@AutoMatter.Field(value="options") Optional<FetchOptions> options, @AutoMatter.Field(value="args") List<String> args) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.options = options;
            this.args = args != null ? args : Collections.emptyList();
        }

        @Override
        @AutoMatter.Field
        public Optional<FetchOptions> options() {
            return this.options;
        }

        @Override
        @AutoMatter.Field
        public List<String> args() {
            return this.args;
        }

        @Override
        public FetchBuilder builder() {
            return new FetchBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Fetch)) {
                return false;
            }
            Fetch that = (Fetch)o;
            if (this.options != null ? !this.options.equals(that.options()) : that.options() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Fetch{options=" + this.options + ", args=" + this.args + '}';
        }
    }
}

