/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.CommandWithoutArgs;
import io.honnix.rkt.launcher.command.GcBuilder;
import io.honnix.rkt.launcher.options.GcOptions;
import io.honnix.rkt.launcher.output.GcOutput;
import io.honnix.rkt.launcher.output.GcOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Gc
extends CommandWithoutArgs<GcOptions, GcOutput> {
    @Override
    public Optional<GcOptions> options();

    @Override
    default public List<String> asList() {
        return this.asList("gc");
    }

    @Override
    default public GcOutput parse(String output) {
        GcOutputBuilder gcOutputBuilder = GcOutput.builder();
        Pattern markedPattern = Pattern.compile("moving pod \"(.+)\" to garbage");
        Pattern removedPattern = Pattern.compile("Garbage collecting pod \"(.+)\"");
        Pattern unremovedPattern = Pattern.compile("pod \"(.+)\" not removed");
        Matcher markedMatcher = markedPattern.matcher(output);
        while (markedMatcher.find()) {
            gcOutputBuilder.marked().add(markedMatcher.group(1));
        }
        Matcher removedMatcher = removedPattern.matcher(output);
        while (removedMatcher.find()) {
            gcOutputBuilder.removed().add(removedMatcher.group(1));
        }
        Matcher unremovedMatcher = unremovedPattern.matcher(output);
        while (unremovedMatcher.find()) {
            gcOutputBuilder.unremoved().add(unremovedMatcher.group(1));
        }
        return gcOutputBuilder.build();
    }

    public static GcBuilder builder() {
        return new GcBuilder();
    }
}

