/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Gc;
import io.honnix.rkt.launcher.options.GcOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class GcBuilder {
    private Optional<GcOptions> options;

    public GcBuilder() {
        this.options = Optional.empty();
    }

    private GcBuilder(Gc v) {
        this.options = v.options();
    }

    private GcBuilder(GcBuilder v) {
        this.options = v.options;
    }

    public Optional<GcOptions> options() {
        return this.options;
    }

    public GcBuilder options(GcOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public GcBuilder options(Optional<? extends GcOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public Gc build() {
        return new Value(this.options);
    }

    public static GcBuilder from(Gc v) {
        return new GcBuilder(v);
    }

    public static GcBuilder from(GcBuilder v) {
        return new GcBuilder(v);
    }

    private static final class Value
    implements Gc {
        private final Optional<GcOptions> options;

        private Value(@AutoMatter.Field(value="options") Optional<GcOptions> options) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.options = options;
        }

        @Override
        @AutoMatter.Field
        public Optional<GcOptions> options() {
            return this.options;
        }

        @Override
        public GcBuilder builder() {
            return new GcBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Gc)) {
                return false;
            }
            Gc that = (Gc)o;
            return !(this.options != null ? !this.options.equals(that.options()) : that.options() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Gc{options=" + this.options + '}';
        }
    }
}

