/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Prepare;
import io.honnix.rkt.launcher.options.PrepareOptions;
import io.norberg.automatter.AutoMatter;
import java.util.Optional;

public final class PrepareBuilder {
    private Optional<PrepareOptions> options;

    public PrepareBuilder() {
        this.options = Optional.empty();
    }

    private PrepareBuilder(Prepare v) {
        this.options = v.options();
    }

    private PrepareBuilder(PrepareBuilder v) {
        this.options = v.options;
    }

    public Optional<PrepareOptions> options() {
        return this.options;
    }

    public PrepareBuilder options(PrepareOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public PrepareBuilder options(Optional<? extends PrepareOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public Prepare build() {
        return new Value(this.options);
    }

    public static PrepareBuilder from(Prepare v) {
        return new PrepareBuilder(v);
    }

    public static PrepareBuilder from(PrepareBuilder v) {
        return new PrepareBuilder(v);
    }

    private static final class Value
    implements Prepare {
        private final Optional<PrepareOptions> options;

        private Value(@AutoMatter.Field(value="options") Optional<PrepareOptions> options) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            this.options = options;
        }

        @Override
        @AutoMatter.Field
        public Optional<PrepareOptions> options() {
            return this.options;
        }

        @Override
        public PrepareBuilder builder() {
            return new PrepareBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Prepare)) {
                return false;
            }
            Prepare that = (Prepare)o;
            return !(this.options != null ? !this.options.equals(that.options()) : that.options() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Prepare{options=" + this.options + '}';
        }
    }
}

