/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import com.google.common.collect.Sets;
import io.honnix.rkt.launcher.command.CommandWithOptionalArgs;
import io.honnix.rkt.launcher.command.RmBuilder;
import io.honnix.rkt.launcher.options.RmOptions;
import io.honnix.rkt.launcher.output.RmOutput;
import io.honnix.rkt.launcher.output.RmOutputBuilder;
import io.norberg.automatter.AutoMatter;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@AutoMatter
public interface Rm
extends CommandWithOptionalArgs<RmOptions, RmOutput> {
    @Override
    public Optional<RmOptions> options();

    @Override
    default public List<String> asList() {
        return this.asList("rm");
    }

    @Override
    default public RmOutput parse(String output) {
        RmOutputBuilder rmOutputBuilder = RmOutput.builder();
        HashSet removed = Sets.newHashSet();
        Pattern removedPattern = Pattern.compile("\"(.+)\"");
        Matcher removedMatcher = removedPattern.matcher(output);
        while (removedMatcher.find()) {
            removed.add(removedMatcher.group(1));
        }
        rmOutputBuilder.removed(removed.iterator());
        return rmOutputBuilder.build();
    }

    public static RmBuilder builder() {
        return new RmBuilder();
    }
}

