/*
 * Decompiled with CFR 0.152.
 */
package io.honnix.rkt.launcher.command;

import io.honnix.rkt.launcher.command.Rm;
import io.honnix.rkt.launcher.options.RmOptions;
import io.norberg.automatter.AutoMatter;
import java.util.List;
import java.util.Optional;

public final class RmBuilder {
    private Optional<RmOptions> options;
    private Optional<List<String>> args;

    public RmBuilder() {
        this.options = Optional.empty();
        this.args = Optional.empty();
    }

    private RmBuilder(Rm v) {
        this.options = v.options();
        this.args = v.args();
    }

    private RmBuilder(RmBuilder v) {
        this.options = v.options;
        this.args = v.args;
    }

    public Optional<RmOptions> options() {
        return this.options;
    }

    public RmBuilder options(RmOptions options) {
        return this.options(Optional.ofNullable(options));
    }

    public RmBuilder options(Optional<? extends RmOptions> options) {
        if (options == null) {
            throw new NullPointerException("options");
        }
        this.options = options;
        return this;
    }

    public Optional<List<String>> args() {
        return this.args;
    }

    public RmBuilder args(List<String> args) {
        return this.args(Optional.ofNullable(args));
    }

    public RmBuilder args(Optional<? extends List<String>> args) {
        if (args == null) {
            throw new NullPointerException("args");
        }
        this.args = args;
        return this;
    }

    public Rm build() {
        return new Value(this.options, this.args);
    }

    public static RmBuilder from(Rm v) {
        return new RmBuilder(v);
    }

    public static RmBuilder from(RmBuilder v) {
        return new RmBuilder(v);
    }

    private static final class Value
    implements Rm {
        private final Optional<RmOptions> options;
        private final Optional<List<String>> args;

        private Value(@AutoMatter.Field(value="options") Optional<RmOptions> options, @AutoMatter.Field(value="args") Optional<List<String>> args) {
            if (options == null) {
                throw new NullPointerException("options");
            }
            if (args == null) {
                throw new NullPointerException("args");
            }
            this.options = options;
            this.args = args;
        }

        @Override
        @AutoMatter.Field
        public Optional<RmOptions> options() {
            return this.options;
        }

        @Override
        @AutoMatter.Field
        public Optional<List<String>> args() {
            return this.args;
        }

        @Override
        public RmBuilder builder() {
            return new RmBuilder(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Rm)) {
                return false;
            }
            Rm that = (Rm)o;
            if (this.options != null ? !this.options.equals(that.options()) : that.options() != null) {
                return false;
            }
            return !(this.args != null ? !this.args.equals(that.args()) : that.args() != null);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Rm{options=" + this.options + ", args=" + this.args + '}';
        }
    }
}

